/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.profile;

import java.time.Instant;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.profile.GameProfile;

public interface GameProfileProvider {
    public CompletableFuture<GameProfile> getBasicProfile(UUID var1);

    default public CompletableFuture<GameProfile> getBasicProfile(String name) {
        return this.getBasicProfile(name, null);
    }

    public CompletableFuture<GameProfile> getBasicProfile(String var1, @Nullable Instant var2);

    default public CompletableFuture<Map<String, GameProfile>> getBasicProfiles(Iterable<String> names) {
        return this.getBasicProfiles(names, null);
    }

    public CompletableFuture<Map<String, GameProfile>> getBasicProfiles(Iterable<String> var1, @Nullable Instant var2);

    default public CompletableFuture<GameProfile> getProfile(GameProfile profile) {
        return this.getProfile(profile.getUniqueId(), true);
    }

    default public CompletableFuture<GameProfile> getProfile(GameProfile profile, boolean signed) {
        return this.getProfile(profile.getUniqueId(), signed);
    }

    default public CompletableFuture<GameProfile> getProfile(String name) {
        return this.getProfile(name, true);
    }

    default public CompletableFuture<GameProfile> getProfile(UUID uniqueId) {
        return this.getProfile(uniqueId, true);
    }

    public CompletableFuture<GameProfile> getProfile(String var1, boolean var2);

    public CompletableFuture<GameProfile> getProfile(UUID var1, boolean var2);
}

