/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.scoreboard.objective;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.kyori.adventure.text.Component;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.scoreboard.Score;
import org.spongepowered.api.scoreboard.Scoreboard;
import org.spongepowered.api.scoreboard.criteria.Criterion;
import org.spongepowered.api.scoreboard.objective.displaymode.ObjectiveDisplayMode;
import org.spongepowered.api.util.CopyableBuilder;

public interface Objective {
    public static Builder builder() {
        return Sponge.getRegistry().getBuilderRegistry().provideBuilder(Builder.class);
    }

    public String getName();

    public Component getDisplayName();

    public void setDisplayName(Component var1) throws IllegalArgumentException;

    public Criterion getCriterion();

    public ObjectiveDisplayMode getDisplayMode();

    public void setDisplayMode(ObjectiveDisplayMode var1);

    public Map<Component, Score> getScores();

    public boolean hasScore(Component var1);

    public void addScore(Score var1) throws IllegalArgumentException;

    default public Optional<Score> getScore(Component name) {
        if (!this.hasScore(name)) {
            return Optional.empty();
        }
        return Optional.of(this.getOrCreateScore(name));
    }

    public Score getOrCreateScore(Component var1);

    public boolean removeScore(Score var1);

    public boolean removeScore(Component var1);

    public Set<Scoreboard> getScoreboards();

    public static interface Builder
    extends CopyableBuilder<Objective, Builder> {
        public Builder name(String var1);

        public Builder displayName(Component var1);

        default public Builder criterion(Supplier<? extends Criterion> criterion) {
            return this.criterion(criterion.get());
        }

        public Builder criterion(Criterion var1);

        default public Builder objectiveDisplayMode(Supplier<? extends ObjectiveDisplayMode> objectiveDisplayMode) {
            return this.objectiveDisplayMode(objectiveDisplayMode.get());
        }

        public Builder objectiveDisplayMode(ObjectiveDisplayMode var1);

        public Objective build() throws IllegalStateException;
    }
}

