/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.service.pagination;

import java.util.Objects;
import java.util.Optional;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.util.CopyableBuilder;

public interface PaginationList {
    public static Builder builder() {
        return Sponge.getServiceProvider().paginationService().builder();
    }

    public Iterable<Component> getContents();

    public Optional<Component> getTitle();

    public Optional<Component> getHeader();

    public Optional<Component> getFooter();

    public Component getPadding();

    public int getLinesPerPage();

    default public void sendTo(Audience receiver) {
        this.sendTo(receiver, 1);
    }

    public void sendTo(Audience var1, int var2);

    default public void sendTo(Iterable<Audience> receivers) {
        this.sendTo(receivers, 1);
    }

    default public void sendTo(Iterable<Audience> receivers, int page) {
        Objects.requireNonNull(receivers, "The iterable of receivers cannot be null!");
        for (Audience receiver : receivers) {
            this.sendTo(receiver, page);
        }
    }

    public static interface Builder
    extends CopyableBuilder<PaginationList, Builder> {
        public Builder contents(Iterable<Component> var1);

        public Builder contents(Component ... var1);

        public Builder title(@Nullable Component var1);

        public Builder header(@Nullable Component var1);

        public Builder footer(@Nullable Component var1);

        public Builder padding(Component var1);

        public Builder linesPerPage(int var1);

        public PaginationList build();

        default public PaginationList sendTo(Audience receiver) {
            PaginationList list = this.build();
            list.sendTo(receiver);
            return list;
        }

        default public PaginationList sendTo(Iterable<Audience> receivers) {
            Objects.requireNonNull(receivers, "The iterable of receivers cannot be null!");
            PaginationList list = this.build();
            for (Audience r : receivers) {
                list.sendTo(r);
            }
            return list;
        }
    }
}

