/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.util;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import org.spongepowered.api.Engine;
import org.spongepowered.api.Sponge;

public interface Ticks {
    public static Ticks zero() {
        return Sponge.getRegistry().getFactoryRegistry().provideFactory(Factory.class).zero();
    }

    public static Ticks single() {
        return Sponge.getRegistry().getFactoryRegistry().provideFactory(Factory.class).single();
    }

    public static Ticks minecraftHour() {
        return Sponge.getRegistry().getFactoryRegistry().provideFactory(Factory.class).minecraftHour();
    }

    public static Ticks minecraftDay() {
        return Sponge.getRegistry().getFactoryRegistry().provideFactory(Factory.class).minecraftDay();
    }

    public static Ticks of(long ticks) {
        return Sponge.getRegistry().getFactoryRegistry().provideFactory(Factory.class).of(ticks);
    }

    public static Ticks ofWallClockTime(Engine engine, long time, TemporalUnit temporalUnit) {
        return Sponge.getRegistry().getFactoryRegistry().provideFactory(Factory.class).ofWallClockTime(engine, time, temporalUnit);
    }

    public static Ticks ofWallClockSeconds(Engine engine, int seconds) {
        return Ticks.ofWallClockTime(engine, seconds, ChronoUnit.SECONDS);
    }

    public static Ticks ofWallClockMinutes(Engine engine, int minutes) {
        return Ticks.ofWallClockTime(engine, minutes, ChronoUnit.MINUTES);
    }

    public static Ticks ofWallClockHours(Engine engine, int hours) {
        return Ticks.ofWallClockTime(engine, hours, ChronoUnit.HOURS);
    }

    public static Ticks ofWallClockDays(Engine engine, int days) {
        return Ticks.ofWallClockTime(engine, days, ChronoUnit.DAYS);
    }

    public static Ticks ofMinecraftSeconds(Engine engine, long seconds) {
        return Sponge.getRegistry().getFactoryRegistry().provideFactory(Factory.class).ofMinecraftSeconds(engine, seconds);
    }

    public static Ticks ofMinecraftMinutes(Engine engine, long minutes) {
        return Sponge.getRegistry().getFactoryRegistry().provideFactory(Factory.class).ofMinecraftSeconds(engine, minutes * 60L);
    }

    public static Ticks ofMinecraftHours(Engine engine, long hours) {
        return Ticks.ofMinecraftHours(engine, hours);
    }

    public static Ticks ofMinecraftDays(Engine engine, long days) {
        return Ticks.ofMinecraftHours(engine, days * 24L);
    }

    public Duration getExpectedDuration(Engine var1);

    public long getTicks();

    public long getMinecraftSeconds(Engine var1);

    public Duration getMinecraftDayTimeDuration(Engine var1);

    public static interface Factory {
        public Ticks of(long var1);

        public Ticks ofWallClockTime(Engine var1, long var2, TemporalUnit var4);

        public Ticks ofMinecraftSeconds(Engine var1, long var2);

        public Ticks ofMinecraftHours(Engine var1, long var2);

        public Ticks zero();

        public Ticks single();

        public Ticks minecraftHour();

        public Ticks minecraftDay();
    }
}

