/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world;

import java.util.Objects;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.util.RandomProvider;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.chunk.ProtoChunk;
import org.spongepowered.api.world.difficulty.Difficulty;
import org.spongepowered.api.world.volume.biome.MutableBiomeVolume;
import org.spongepowered.api.world.volume.block.MutableBlockVolume;
import org.spongepowered.api.world.volume.block.PhysicsAwareMutableBlockVolume;
import org.spongepowered.api.world.volume.block.entity.MutableBlockEntityVolume;
import org.spongepowered.api.world.volume.entity.MutableEntityVolume;
import org.spongepowered.api.world.volume.game.GenerationVolume;
import org.spongepowered.api.world.volume.game.LocationBaseDataHolder;
import org.spongepowered.api.world.volume.game.MutableGameVolume;
import org.spongepowered.api.world.volume.game.ReadableRegion;
import org.spongepowered.api.world.volume.game.UpdatableVolume;
import org.spongepowered.math.vector.Vector3i;

public interface ProtoWorld<P extends ProtoWorld<P>>
extends ReadableRegion<P>,
MutableBiomeVolume<P>,
MutableBlockVolume<P>,
MutableEntityVolume<P>,
MutableBlockEntityVolume<P>,
GenerationVolume,
LocationBaseDataHolder.Mutable,
UpdatableVolume,
RandomProvider,
PhysicsAwareMutableBlockVolume<P>,
MutableGameVolume {
    @Override
    public ProtoChunk<?> getChunk(int var1, int var2, int var3);

    public long getSeed();

    public Difficulty getDifficulty();

    @Override
    default public boolean setBlock(Vector3i position, BlockState state, BlockChangeFlag flag) {
        Objects.requireNonNull(position);
        Objects.requireNonNull(state);
        Objects.requireNonNull(flag);
        return this.setBlock(position.getX(), position.getY(), position.getZ(), state, flag);
    }

    @Override
    public boolean setBlock(int var1, int var2, int var3, BlockState var4, BlockChangeFlag var5);

    @Override
    default public boolean removeBlock(Vector3i position) {
        Objects.requireNonNull(position);
        return this.removeBlock(position.getX(), position.getY(), position.getZ());
    }

    @Override
    public boolean removeBlock(int var1, int var2, int var3);
}

