/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world;

import java.time.Duration;
import java.time.temporal.TemporalUnit;
import java.util.Collection;
import java.util.function.BiFunction;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DirectionRelativeDataHolder;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.fluid.FluidType;
import org.spongepowered.api.scheduler.ScheduledUpdate;
import org.spongepowered.api.scheduler.TaskPriority;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

public interface ServerLocation
extends DataHolder.Mutable,
DirectionRelativeDataHolder.Mutable,
Location<ServerWorld> {
    public static ServerLocation of(ServerWorld world, double x, double y, double z) {
        return Sponge.getRegistry().getFactoryRegistry().provideFactory(Factory.class).create(world, new Vector3d(x, y, z));
    }

    public static ServerLocation of(ResourceKey worldKey, double x, double y, double z) {
        return Sponge.getRegistry().getFactoryRegistry().provideFactory(Factory.class).create(worldKey, new Vector3d(x, y, z));
    }

    public static ServerLocation of(ServerWorld world, Vector3d position) {
        return Sponge.getRegistry().getFactoryRegistry().provideFactory(Factory.class).create(world, position);
    }

    public static ServerLocation of(ResourceKey worldKey, Vector3d position) {
        return Sponge.getRegistry().getFactoryRegistry().provideFactory(Factory.class).create(worldKey, position);
    }

    public static ServerLocation of(ServerWorld world, int x, int y, int z) {
        return Sponge.getRegistry().getFactoryRegistry().provideFactory(Factory.class).create(world, new Vector3i(x, y, z));
    }

    public static ServerLocation of(ResourceKey worldKey, int x, int y, int z) {
        return Sponge.getRegistry().getFactoryRegistry().provideFactory(Factory.class).create(worldKey, new Vector3i(x, y, z));
    }

    public static ServerLocation of(ServerWorld world, Vector3i position) {
        return Sponge.getRegistry().getFactoryRegistry().provideFactory(Factory.class).create(world, position);
    }

    public static ServerLocation of(ResourceKey worldKey, Vector3i position) {
        return Sponge.getRegistry().getFactoryRegistry().provideFactory(Factory.class).create(worldKey, position);
    }

    public ResourceKey getWorldKey();

    public LocatableBlock asLocatableBlock();

    public <T> T map(BiFunction<ServerWorld, Vector3d, T> var1);

    public <T> T mapBlock(BiFunction<ServerWorld, Vector3i, T> var1);

    public <T> T mapChunk(BiFunction<ServerWorld, Vector3i, T> var1);

    public <T> T mapBiome(BiFunction<ServerWorld, Vector3i, T> var1);

    public boolean restoreSnapshot(BlockSnapshot var1, boolean var2, BlockChangeFlag var3);

    public boolean removeBlock();

    public <E extends Entity> E createEntity(EntityType<E> var1);

    public boolean spawnEntity(Entity var1);

    public Collection<Entity> spawnEntities(Iterable<? extends Entity> var1);

    public ServerLocation asHighestLocation();

    public BlockSnapshot createSnapshot();

    public Collection<? extends ScheduledUpdate<BlockType>> getScheduledBlockUpdates();

    public ScheduledUpdate<BlockType> scheduleBlockUpdate(int var1, TemporalUnit var2);

    public ScheduledUpdate<BlockType> scheduleBlockUpdate(int var1, TemporalUnit var2, TaskPriority var3);

    public ScheduledUpdate<BlockType> scheduleBlockUpdate(Duration var1);

    public ScheduledUpdate<BlockType> scheduleBlockUpdate(Duration var1, TaskPriority var2);

    public Collection<? extends ScheduledUpdate<FluidType>> getScheduledFluidUpdates();

    public ScheduledUpdate<FluidType> scheduleFluidUpdate(int var1, TemporalUnit var2);

    public ScheduledUpdate<FluidType> scheduleFluidUpdate(int var1, TemporalUnit var2, TaskPriority var3);

    public ScheduledUpdate<FluidType> scheduleFluidUpdate(Duration var1);

    public ScheduledUpdate<FluidType> scheduleFluidUpdate(Duration var1, TaskPriority var2);

    public ServerLocation withWorld(ServerWorld var1);

    public ServerLocation withPosition(Vector3d var1);

    public ServerLocation withBlockPosition(Vector3i var1);

    public ServerLocation sub(Vector3d var1);

    public ServerLocation sub(Vector3i var1);

    public ServerLocation sub(double var1, double var3, double var5);

    public ServerLocation add(Vector3d var1);

    public ServerLocation add(Vector3i var1);

    public ServerLocation add(double var1, double var3, double var5);

    public ServerLocation relativeTo(Direction var1);

    public ServerLocation relativeToBlock(Direction var1);

    public static interface Factory {
        public ServerLocation create(ServerWorld var1, Vector3d var2);

        public ServerLocation create(ServerWorld var1, Vector3i var2);

        public ServerLocation create(ResourceKey var1, Vector3d var2);

        public ServerLocation create(ResourceKey var1, Vector3i var2);
    }
}

