/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.ForwardingAudience;
import org.spongepowered.api.Engine;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.effect.Viewer;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.service.context.ContextSource;
import org.spongepowered.api.util.annotation.DoNotStore;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.LocationCreator;
import org.spongepowered.api.world.ProtoWorld;
import org.spongepowered.api.world.chunk.Chunk;
import org.spongepowered.api.world.volume.archetype.ArchetypeVolumeCreator;
import org.spongepowered.api.world.volume.block.PhysicsAwareMutableBlockVolume;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

@DoNotStore
public interface World<W extends World<W>>
extends ForwardingAudience,
ProtoWorld<W>,
LocationCreator,
PhysicsAwareMutableBlockVolume<W>,
ContextSource,
Viewer,
ArchetypeVolumeCreator {
    public Engine getEngine();

    public boolean isLoaded();

    @Override
    public Collection<? extends Player> getPlayers();

    default public Iterable<? extends Audience> audiences() {
        return this.getPlayers();
    }

    default public Optional<? extends Player> getClosestPlayer(Vector3i position, double distance) {
        return this.getClosestPlayer(position.getX(), position.getY(), position.getZ(), distance, player -> true);
    }

    default public Optional<? extends Player> getClosestPlayer(Vector3i position, double distance, Predicate<? super Player> predicate) {
        return this.getClosestPlayer(position.getX(), position.getY(), position.getZ(), distance, predicate);
    }

    default public Optional<? extends Player> getClosestPlayer(Entity entity, double distance) {
        Vector3d position = entity.getLocation().getPosition();
        return this.getClosestPlayer(position.getFloorX(), position.getFloorY(), position.getFloorZ(), distance, player -> true);
    }

    default public Optional<? extends Player> getClosestPlayer(Entity entity, double distance, Predicate<? super Player> predicate) {
        Vector3d position = entity.getLocation().getPosition();
        return this.getClosestPlayer(position.getFloorX(), position.getFloorY(), position.getFloorZ(), distance, predicate);
    }

    default public Optional<? extends Player> getClosestPlayer(int x, int y, int z, double distance) {
        return this.getClosestPlayer(x, y, z, distance, player -> true);
    }

    public Optional<? extends Player> getClosestPlayer(int var1, int var2, int var3, double var4, Predicate<? super Player> var6);

    default public BlockSnapshot createSnapshot(Vector3i position) {
        Objects.requireNonNull(position);
        return this.createSnapshot(position.getX(), position.getY(), position.getZ());
    }

    public BlockSnapshot createSnapshot(int var1, int var2, int var3);

    public boolean restoreSnapshot(BlockSnapshot var1, boolean var2, BlockChangeFlag var3);

    default public boolean restoreSnapshot(Vector3i position, BlockSnapshot snapshot, boolean force, BlockChangeFlag flag) {
        return this.restoreSnapshot(position.getX(), position.getY(), position.getZ(), snapshot, force, flag);
    }

    public boolean restoreSnapshot(int var1, int var2, int var3, BlockSnapshot var4, boolean var5, BlockChangeFlag var6);

    default public Chunk getChunkAtBlock(Vector3i blockPosition) {
        Objects.requireNonNull(blockPosition);
        Vector3i chunkPos = Sponge.getServer().getChunkLayout().forceToChunk(blockPosition);
        return this.getChunk(chunkPos.getX(), chunkPos.getY(), chunkPos.getZ());
    }

    public Chunk getChunkAtBlock(int var1, int var2, int var3);

    default public Chunk getChunk(Vector3i chunkPos) {
        Objects.requireNonNull(chunkPos);
        return this.getChunk(chunkPos.getX(), chunkPos.getY(), chunkPos.getZ());
    }

    public Chunk getChunk(int var1, int var2, int var3);

    default public Optional<Chunk> loadChunk(Vector3i chunkPosition, boolean shouldGenerate) {
        Objects.requireNonNull(chunkPosition);
        return this.loadChunk(chunkPosition.getX(), chunkPosition.getY(), chunkPosition.getZ(), shouldGenerate);
    }

    public Optional<Chunk> loadChunk(int var1, int var2, int var3, boolean var4);

    public Iterable<Chunk> getLoadedChunks();

    public boolean allowsPlayerRespawns();

    public boolean doesWaterEvaporate();

    public boolean hasSkylight();

    public boolean isCaveWorld();

    public boolean isSurfaceWorld();
}

