/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world;

import java.util.function.Supplier;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.util.CatalogBuilder;
import org.spongepowered.api.util.CopyableBuilder;
import org.spongepowered.api.util.annotation.CatalogedBy;
import org.spongepowered.api.world.SerializationBehavior;
import org.spongepowered.api.world.WorldArchetypes;
import org.spongepowered.api.world.difficulty.Difficulty;
import org.spongepowered.api.world.dimension.DimensionType;
import org.spongepowered.api.world.gen.GeneratorModifierType;
import org.spongepowered.api.world.storage.WorldProperties;

@CatalogedBy(value={WorldArchetypes.class})
public interface WorldArchetype
extends CatalogType {
    public static Builder builder() {
        return Sponge.getRegistry().getBuilderRegistry().provideBuilder(Builder.class);
    }

    public boolean isEnabled();

    public boolean doesLoadOnStartup();

    public boolean doesKeepSpawnLoaded();

    public boolean doesGenerateSpawnOnLoad();

    public long getSeed();

    public boolean isSeedRandomized();

    public GameMode getGameMode();

    public DimensionType getDimensionType();

    public GeneratorModifierType getGeneratorModifier();

    public boolean areStructuresEnabled();

    public boolean isHardcore();

    public boolean areCommandsEnabled();

    public boolean doesGenerateBonusChest();

    public Difficulty getDifficulty();

    public boolean isPVPEnabled();

    public SerializationBehavior getSerializationBehavior();

    public DataContainer getGeneratorSettings();

    public static interface Builder
    extends CatalogBuilder<WorldArchetype, Builder>,
    CopyableBuilder<WorldArchetype, Builder> {
        public Builder enabled(boolean var1);

        public Builder loadOnStartup(boolean var1);

        public Builder keepSpawnLoaded(boolean var1);

        public Builder generateSpawnOnLoad(boolean var1);

        public Builder seed(long var1);

        public Builder randomSeed();

        default public Builder gameMode(Supplier<? extends GameMode> gameMode) {
            return this.gameMode(gameMode.get());
        }

        public Builder gameMode(GameMode var1);

        default public Builder dimensionType(Supplier<? extends DimensionType> type) {
            return this.dimensionType(type.get());
        }

        public Builder dimensionType(DimensionType var1);

        default public Builder generatorModifierType(Supplier<? extends GeneratorModifierType> modifier) {
            return this.generatorModifierType(modifier.get());
        }

        public Builder generatorModifierType(GeneratorModifierType var1);

        default public Builder difficulty(Supplier<? extends Difficulty> difficulty) {
            return this.difficulty(difficulty.get());
        }

        public Builder difficulty(Difficulty var1);

        public Builder generateStructures(boolean var1);

        public Builder hardcore(boolean var1);

        public Builder pvpEnabled(boolean var1);

        public Builder commandsEnabled(boolean var1);

        public Builder generateBonusChest(boolean var1);

        default public Builder serializationBehavior(Supplier<? extends SerializationBehavior> behavior) {
            return this.serializationBehavior(behavior.get());
        }

        public Builder serializationBehavior(SerializationBehavior var1);

        public Builder generatorSettings(DataContainer var1);

        @Override
        public Builder from(WorldProperties var1);

        @Override
        public WorldArchetype build();
    }
}

