/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.server;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Server;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.raid.Raid;
import org.spongepowered.api.util.Identifiable;
import org.spongepowered.api.world.ChunkRegenerateFlag;
import org.spongepowered.api.world.ChunkRegenerateFlags;
import org.spongepowered.api.world.LocationCreator;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.chunk.Chunk;
import org.spongepowered.api.world.difficulty.Difficulty;
import org.spongepowered.api.world.explosion.Explosion;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.api.world.storage.WorldStorage;
import org.spongepowered.api.world.volume.game.InteractableVolume;
import org.spongepowered.api.world.weather.WeatherUniverse;
import org.spongepowered.math.vector.Vector3i;

public interface ServerWorld
extends World<ServerWorld>,
Identifiable,
InteractableVolume,
LocationCreator,
WeatherUniverse {
    @Override
    public Server getEngine();

    public WorldProperties getProperties();

    default public ResourceKey getKey() {
        return this.getProperties().getKey();
    }

    @Override
    default public UUID getUniqueId() {
        return this.getProperties().getUniqueId();
    }

    @Override
    default public Difficulty getDifficulty() {
        return this.getProperties().getDifficulty();
    }

    @Override
    default public Chunk getChunkAtBlock(int bx, int by, int bz) {
        Vector3i chunkPos = this.getEngine().getChunkLayout().forceToChunk(bx, by, bz);
        return this.getChunk(chunkPos.getX(), chunkPos.getY(), chunkPos.getZ());
    }

    default public Optional<Chunk> regenerateChunk(Vector3i chunkPosition) {
        return this.regenerateChunk(chunkPosition.getX(), chunkPosition.getY(), chunkPosition.getZ(), ChunkRegenerateFlags.ALL);
    }

    default public Optional<Chunk> regenerateChunk(int cx, int cy, int cz) {
        return this.regenerateChunk(cx, cy, cz, ChunkRegenerateFlags.ALL);
    }

    default public Optional<Chunk> regenerateChunk(Vector3i chunkPosition, ChunkRegenerateFlag flag) {
        return this.regenerateChunk(chunkPosition.getX(), chunkPosition.getY(), chunkPosition.getZ(), flag);
    }

    public Optional<Chunk> regenerateChunk(int var1, int var2, int var3, ChunkRegenerateFlag var4);

    public Path getDirectory();

    public WorldStorage getWorldStorage();

    public boolean save() throws IOException;

    public boolean unloadChunk(Chunk var1);

    public void triggerExplosion(Explosion var1);

    @Override
    public Collection<ServerPlayer> getPlayers();

    public Collection<? extends Entity> getEntities();

    public Collection<Raid> getRaids();

    public Optional<Raid> getRaidAt(Vector3i var1);
}

