/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.volume.entity;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.world.volume.MutableVolume;
import org.spongepowered.api.world.volume.block.MutableBlockVolume;
import org.spongepowered.api.world.volume.entity.StreamableEntityVolume;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

public interface MutableEntityVolume<M extends MutableEntityVolume<M>>
extends StreamableEntityVolume<M>,
MutableVolume,
MutableBlockVolume<M> {
    public <E extends Entity> E createEntity(EntityType<E> var1, Vector3d var2) throws IllegalArgumentException, IllegalStateException;

    default public <E extends Entity> E createEntity(Supplier<EntityType<E>> type, Vector3d position) throws IllegalArgumentException, IllegalStateException {
        return this.createEntity(type.get(), position);
    }

    default public <E extends Entity> E createEntity(EntityType<E> type, Vector3i position) throws IllegalArgumentException, IllegalStateException {
        Objects.requireNonNull(position, "position");
        return this.createEntity(type, position.toDouble());
    }

    default public <E extends Entity> E createEntity(Supplier<EntityType<E>> type, Vector3i position) throws IllegalArgumentException, IllegalStateException {
        return this.createEntity(type.get(), position);
    }

    public <E extends Entity> E createEntityNaturally(EntityType<E> var1, Vector3d var2) throws IllegalArgumentException, IllegalStateException;

    default public <E extends Entity> E createEntityNaturally(Supplier<EntityType<E>> type, Vector3d position) throws IllegalArgumentException, IllegalStateException {
        return this.createEntityNaturally(type.get(), position);
    }

    default public <E extends Entity> E createEntityNaturally(EntityType<E> type, Vector3i position) throws IllegalArgumentException, IllegalStateException {
        Objects.requireNonNull(position, "position");
        return this.createEntityNaturally(type, position.toDouble());
    }

    default public <E extends Entity> E createEntityNaturally(Supplier<EntityType<E>> type, Vector3i position) throws IllegalArgumentException, IllegalStateException {
        return this.createEntityNaturally(type.get(), position);
    }

    public Optional<Entity> createEntity(DataContainer var1);

    public Optional<Entity> createEntity(DataContainer var1, Vector3d var2);

    public boolean spawnEntity(Entity var1);

    public Collection<Entity> spawnEntities(Iterable<? extends Entity> var1);
}

