/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.volume.entity;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityPredicates;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.util.AABB;
import org.spongepowered.api.world.volume.Volume;
import org.spongepowered.math.vector.Vector3d;

public interface ReadableEntityVolume
extends Volume {
    public Collection<? extends Player> getPlayers();

    public Optional<Entity> getEntity(UUID var1);

    default public Collection<? extends Entity> getEntities(AABB box) {
        Objects.requireNonNull(box);
        return this.getEntities(box, (? super Entity entity) -> true);
    }

    public <T extends Entity> Collection<? extends T> getEntities(Class<? extends T> var1, AABB var2, @Nullable Predicate<? super T> var3);

    public Collection<? extends Entity> getEntities(AABB var1, Predicate<? super Entity> var2);

    default public <T extends Entity> Collection<? extends T> getEntities(Class<? extends T> entityClass, AABB box) {
        return this.getEntities(entityClass, box, EntityPredicates.NO_SPECTATOR);
    }

    default public Optional<? extends Player> getNearestPlayer(double x, double y, double z, double distance, @Nullable Predicate<? super Entity> predicate) {
        Player nearest = null;
        double closest = -1.0;
        for (Player player : this.getPlayers()) {
            if (predicate != null && !predicate.test(player)) continue;
            double dist = player.getPosition().distanceSquared(x, y, z);
            if (!(closest < 0.0) && !(dist < distance * distance) || closest != -1.0 && !(dist < distance)) continue;
            nearest = player;
            closest = dist;
        }
        return Optional.ofNullable(nearest);
    }

    default public Collection<? extends Entity> getNearbyEntities(Vector3d location, double distance) {
        Objects.requireNonNull(location);
        if (distance <= 0.0) {
            throw new IllegalArgumentException("Distance must be a positive number!");
        }
        return this.getEntities(new AABB(location.getX() - distance, location.getY() - distance, location.getZ() - distance, location.getX() + distance, location.getY() + distance, location.getZ() + distance), (? super Entity entity) -> entity.getLocation().getPosition().distanceSquared(location) <= distance * distance);
    }
}

