/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common;

import co.aikar.timings.TimingsFactory;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import io.leangen.geantyref.TypeToken;
import java.util.Collection;
import java.util.stream.Collectors;
import org.spongepowered.api.Engine;
import org.spongepowered.api.Game;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.advancement.Advancement;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.item.recipe.RecipeRegistration;
import org.spongepowered.common.SpongeServer;
import org.spongepowered.common.advancement.SpongeAdvancementProvider;
import org.spongepowered.common.bridge.server.MinecraftServerBridge;
import org.spongepowered.common.command.manager.SpongeCommandManager;
import org.spongepowered.common.data.SpongeDataManager;
import org.spongepowered.common.event.SpongeEventManager;
import org.spongepowered.common.event.lifecycle.RegisterBuilderEventImpl;
import org.spongepowered.common.event.lifecycle.RegisterCatalogRegistryEventImpl;
import org.spongepowered.common.event.lifecycle.RegisterFactoryEventImpl;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.item.recipe.SpongeRecipeProvider;
import org.spongepowered.common.launch.plugin.DummyPluginContainer;
import org.spongepowered.common.network.channel.SpongeChannelRegistry;
import org.spongepowered.common.registry.SpongeBuilderRegistry;
import org.spongepowered.common.registry.SpongeCatalogRegistry;
import org.spongepowered.common.registry.SpongeFactoryRegistry;
import org.spongepowered.common.relocate.co.aikar.timings.SpongeTimingsFactory;
import org.spongepowered.common.service.SpongeServiceProvider;
import org.spongepowered.plugin.PluginContainer;

@Singleton
public final class SpongeLifecycle {
    private final Game game;
    private final Injector injector;

    @Inject
    public SpongeLifecycle(Game game, Injector injector) {
        this.game = game;
        this.injector = injector;
    }

    public void establishFactories() {
        ((SpongeFactoryRegistry)this.game.getRegistry().getFactoryRegistry()).registerDefaultFactories();
    }

    public void establishBuilders() {
        ((SpongeBuilderRegistry)this.game.getRegistry().getBuilderRegistry()).registerDefaultBuilders();
        ((SpongeDataManager)this.game.getDataManager()).registerDefaultBuilders();
    }

    public void callRegisterFactoryEvent() {
        this.game.getEventManager().post(new RegisterFactoryEventImpl(Cause.of(EventContext.empty(), this.game), this.game));
    }

    public void callRegisterBuilderEvent() {
        this.game.getEventManager().post(new RegisterBuilderEventImpl(Cause.of(EventContext.empty(), this.game), this.game));
    }

    public void establishRegistries() {
        SpongeCatalogRegistry spongeCatalogRegistry = (SpongeCatalogRegistry)this.game.getRegistry().getCatalogRegistry();
        spongeCatalogRegistry.registerDefaultRegistries();
        spongeCatalogRegistry.registerDefaultSuppliers();
        this.game.getEventManager().post(new RegisterCatalogRegistryEventImpl(Cause.of(EventContext.empty(), this.game), this.game));
        spongeCatalogRegistry.callRegisterCatalogEvents(Cause.of(EventContext.empty(), this.game), this.game);
    }

    public void establishDataPackRegistries() {
        SpongeCatalogRegistry spongeCatalogRegistry = (SpongeCatalogRegistry)this.game.getRegistry().getCatalogRegistry();
        spongeCatalogRegistry.callDataPackRegisterCatalogEvents(Cause.of(EventContext.empty(), this.game), this.game);
        SpongeRecipeProvider.registerRecipes(spongeCatalogRegistry.getRegistry(RecipeRegistration.class));
        SpongeAdvancementProvider.registerAdvancements(spongeCatalogRegistry.getRegistry(Advancement.class));
    }

    public void callRegisterChannelEvent() {
        ((SpongeChannelRegistry)this.game.getChannelRegistry()).postRegistryEvent();
    }

    public void initTimings() {
        ((SpongeTimingsFactory)Sponge.getRegistry().getFactoryRegistry().provideFactory(TimingsFactory.class)).init();
    }

    public void establishGameServices() {
        ((SpongeServiceProvider)((Object)this.game.getServiceProvider())).init();
    }

    public void establishServerServices() {
        ((MinecraftServerBridge)((Object)this.game.getServer())).bridge$initServices(this.game, this.injector);
    }

    public void establishServerFeatures() {
        ((SpongeServer)this.game.getServer()).getUsernameCache().load();
    }

    public void establishCommands() {
        ((SpongeCommandManager)this.game.getCommandManager()).init();
    }

    public void registerPluginListeners() {
        for (PluginContainer plugin : this.filterInternalPlugins(this.game.getPluginManager().getPlugins())) {
            this.game.getEventManager().registerListeners(plugin, plugin.getInstance());
        }
    }

    public void callConstructEvent() {
        for (PluginContainer plugin : this.filterInternalPlugins(this.game.getPluginManager().getPlugins())) {
            ((SpongeEventManager)this.game.getEventManager()).post((Event)SpongeEventFactory.createConstructPluginEvent(Cause.of(EventContext.empty(), this.game), this.game, plugin), plugin);
        }
    }

    public void callStartingEngineEvent(Engine engine) {
        this.game.getEventManager().post(SpongeEventFactory.createStartingEngineEvent(PhaseTracker.getCauseStackManager().getCurrentCause(), engine, this.game, TypeToken.get(engine.getClass())));
    }

    public void callStartedEngineEvent(Engine engine) {
        this.game.getEventManager().post(SpongeEventFactory.createStartedEngineEvent(PhaseTracker.getCauseStackManager().getCurrentCause(), engine, this.game, TypeToken.get(engine.getClass())));
    }

    public void callLoadedGameEvent() {
        this.game.getEventManager().post(SpongeEventFactory.createLoadedGameEvent(PhaseTracker.getCauseStackManager().getCurrentCause(), this.game));
    }

    public void callStoppingEngineEvent(Engine engine) {
        this.game.getEventManager().post(SpongeEventFactory.createStoppingEngineEvent(PhaseTracker.getCauseStackManager().getCurrentCause(), engine, this.game, TypeToken.get(engine.getClass())));
    }

    private Collection<PluginContainer> filterInternalPlugins(Collection<PluginContainer> plugins) {
        return plugins.stream().filter(plugin -> !(plugin instanceof DummyPluginContainer)).collect(Collectors.toList());
    }

    public void establishDataProviders() {
        ((SpongeDataManager)Sponge.getGame().getDataManager()).registerDefaultProviders();
    }

    public void establishDataKeyListeners() {
        ((SpongeDataManager)Sponge.getGame().getDataManager()).registerKeyListeners();
    }
}

