/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common;

import com.google.common.base.MoreObjects;
import java.util.OptionalInt;
import org.spongepowered.api.MinecraftVersion;
import org.spongepowered.common.ProtocolMinecraftVersion;

public final class SpongeMinecraftVersion
implements ProtocolMinecraftVersion,
MinecraftVersion {
    private final String name;
    private final int protocol;

    public SpongeMinecraftVersion(String name, int protocol) {
        this.name = name;
        this.protocol = protocol;
    }

    public static int compare(ProtocolMinecraftVersion version, MinecraftVersion to) {
        if (version.equals(to)) {
            return 0;
        }
        if (to.isLegacy()) {
            return 1;
        }
        return version.getProtocol() - ((ProtocolMinecraftVersion)((Object)to)).getProtocol();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getProtocol() {
        return this.protocol;
    }

    @Override
    public boolean isLegacy() {
        return false;
    }

    @Override
    public OptionalInt getDataVersion() {
        return OptionalInt.of(2230);
    }

    @Override
    public int compareTo(MinecraftVersion o) {
        return SpongeMinecraftVersion.compare(this, o);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProtocolMinecraftVersion)) {
            return false;
        }
        ProtocolMinecraftVersion that = (ProtocolMinecraftVersion)o;
        return this.getProtocol() == that.getProtocol();
    }

    public int hashCode() {
        return this.protocol;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("protocol", this.protocol).toString();
    }
}

