/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.advancement;

import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.util.registry.Registry;
import org.apache.commons.io.FileUtils;
import org.spongepowered.api.advancement.Advancement;

public final class SpongeAdvancementProvider {
    private static final int PACK_VERSION_1_15 = 6;

    public static void registerAdvancements(Registry<Advancement> advancements) {
        Path datapackPluginAdvancements = Paths.get("world", new String[0]).resolve("datapacks").resolve("plugin-advancements");
        try {
            FileUtils.deleteDirectory((File)datapackPluginAdvancements.toFile());
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not clear plugin-advancements datapack.", e);
        }
        for (Advancement advancement : advancements) {
            net.minecraft.advancements.Advancement mcAdvancement = (net.minecraft.advancements.Advancement)advancement;
            SpongeAdvancementProvider.save(datapackPluginAdvancements, mcAdvancement);
        }
        if (!advancements.keySet().isEmpty()) {
            Path packMeta = datapackPluginAdvancements.resolve("pack.mcmeta");
            JsonObject packDataRoot = new JsonObject();
            JsonObject packData = new JsonObject();
            packDataRoot.add("pack", packData);
            packData.addProperty("pack_format", 6);
            packData.addProperty("description", "Sponge Plugin provided Advancements");
            SpongeAdvancementProvider.saveToFile(packDataRoot, packMeta);
        }
    }

    private static void save(Path datpackPath, net.minecraft.advancements.Advancement advancement) {
        Path namespacedData = datpackPath.resolve("data").resolve(advancement.getId().getNamespace());
        Path advancementFile = namespacedData.resolve("advancements").resolve(advancement.getId().getPath() + ".json");
        SpongeAdvancementProvider.saveToFile(advancement.copy().serialize(), advancementFile);
    }

    private static void saveToFile(JsonObject json, Path pathIn) {
        try {
            Files.createDirectories(pathIn.getParent(), new FileAttribute[0]);
            try (BufferedWriter bufferedwriter = Files.newBufferedWriter(pathIn, new OpenOption[0]);){
                bufferedwriter.write(json.toString());
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

