/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.adventure;

import java.text.AttributedCharacterIterator;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import net.kyori.adventure.translation.GlobalTranslator;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.HoverEvent;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class NativeComponentRenderer<C> {
    static final NativeComponentRenderer<Locale> INSTANCE = new NativeComponentRenderer<Locale>(){

        @Override
        public MessageFormat translate(@NonNull String key, @NonNull Locale locale) {
            return GlobalTranslator.get().translate(key, locale);
        }
    };

    public static @NonNull NativeComponentRenderer<Locale> get() {
        return INSTANCE;
    }

    protected abstract @Nullable MessageFormat translate(@NonNull String var1, @NonNull C var2);

    public ITextComponent render(@NonNull ITextComponent component, @NonNull C context) {
        ITextComponent rendered;
        ITextComponent original;
        if (component instanceof TranslationTextComponent) {
            component = this.renderTranslatable((TranslationTextComponent)component, context);
        } else {
            this.renderSiblings(component, context);
        }
        HoverEvent hover = component.getStyle().getHoverEvent();
        if (hover != null && (original = hover.getValue()) != (rendered = this.render(original, context))) {
            component.getStyle().setHoverEvent(new HoverEvent(hover.getAction(), rendered));
        }
        return component;
    }

    protected @NonNull ITextComponent renderTranslatable(@NonNull TranslationTextComponent component, @NonNull C context) {
        StringTextComponent result;
        MessageFormat format = this.translate(component.getKey(), context);
        if (format == null) {
            Object[] args = component.getFormatArgs();
            if (args.length > 0) {
                int size = args.length;
                for (int i = 0; i < size; ++i) {
                    if (!(args[i] instanceof ITextComponent)) continue;
                    args[i] = this.render((ITextComponent)args[i], context);
                }
            }
            this.renderSiblings((ITextComponent)component, context);
            return component;
        }
        Object[] args = component.getFormatArgs();
        if (args.length == 0) {
            result = new StringTextComponent(format.format(null, new StringBuffer(), null).toString());
        } else {
            result = new StringTextComponent("");
            Object[] nulls = new Object[args.length];
            StringBuffer sb = format.format(nulls, new StringBuffer(), (FieldPosition)null);
            AttributedCharacterIterator it = format.formatToCharacterIterator(nulls);
            while (it.getIndex() < it.getEndIndex()) {
                int end = it.getRunLimit();
                Integer index = (Integer)it.getAttribute(MessageFormat.Field.ARGUMENT);
                if (index != null && args[index] instanceof ITextComponent) {
                    result.appendSibling(this.render((ITextComponent)args[index], context));
                } else {
                    result.appendSibling((ITextComponent)new StringTextComponent(sb.substring(it.getIndex(), end)));
                }
                it.setIndex(end);
            }
        }
        result.setStyle(component.getStyle());
        this.renderSiblings((ITextComponent)component, context, (idx, rendered) -> result.appendSibling(rendered));
        return result;
    }

    private void renderSiblings(ITextComponent component, C context) {
        this.renderSiblings(component, context, component.getSiblings()::set);
    }

    private void renderSiblings(ITextComponent component, C context, SiblingConsumer consumer) {
        List siblings = component.getSiblings();
        for (int i = 0; i < siblings.size(); ++i) {
            ITextComponent original = (ITextComponent)siblings.get(i);
            ITextComponent rendered = this.render(original, context);
            consumer.accept(i, rendered);
        }
    }

    @FunctionalInterface
    static interface SiblingConsumer {
        public void accept(int var1, ITextComponent var2);
    }
}

