/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.applaunch.config.common;

import org.spongepowered.common.applaunch.config.core.TokenHoldingString;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.meta.Comment;
import org.spongepowered.configurate.objectmapping.meta.Setting;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@ConfigSerializable
public class GeneralCategory {
    @Setting(value="file-io-thread-sleep")
    @Comment(value="If 'true', sleeping between chunk saves will be enabled, beware of memory issues.")
    private boolean fileIOThreadSleep = false;
    @Setting(value="plugins-dir")
    @Comment(value="Additional directory to search for plugins, relative to the \nexecution root or specified as an absolute path. \nNote that the default: \"${CANONICAL_MODS_DIR}/plugins\" \nis going to search for a plugins folder in the mods directory. \nIf you wish for the plugins folder to reside in the root game \ndirectory, change the value to \"${CANONICAL_GAME_DIR}/plugins\".")
    private TokenHoldingString pluginsDir = TokenHoldingString.of("${CANONICAL_MODS_DIR}/plugins");
    @Setting(value="config-dir")
    @Comment(value="The directory for Sponge plugin configurations, relative to the  \nexecution root or specified as an absolute path. \nNote that the default: \"${CANONICAL_GAME_DIR}/config\" \nis going to use the \"config\" directory in the root game directory. \nIf you wish for plugin configs to reside within a child of the configuration \ndirectory, change the value to, for example, \"${CANONICAL_CONFIG_DIR}/sponge/plugins\". \nNote: It is not recommended to set this to \"${CANONICAL_CONFIG_DIR}/sponge\", as there is \na possibility that plugin configurations can conflict the Sponge core configurations. \n")
    private TokenHoldingString configDir = TokenHoldingString.of("${CANONICAL_GAME_DIR}/config");

    public boolean getFileIoThreadSleep() {
        return this.fileIOThreadSleep;
    }

    public String pluginsDir() {
        return this.pluginsDir.getParsed();
    }

    public void setPluginsDir(String pluginsDir) {
        this.pluginsDir = TokenHoldingString.of(pluginsDir);
    }

    public String configDir() {
        return this.configDir.getParsed();
    }

    public void setConfigDir(String configDir) {
        this.configDir = TokenHoldingString.of(configDir);
    }
}

