/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.asset;

import com.google.common.base.Preconditions;
import com.google.inject.Singleton;
import java.net.URL;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.asset.Asset;
import org.spongepowered.api.asset.AssetManager;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.asset.SpongeAsset;
import org.spongepowered.plugin.PluginContainer;

@Singleton
public final class SpongeAssetManager
implements AssetManager {
    private static final String DEFAULT_ASSET_DIR = "assets/";
    private static final ClassLoader CLASS_LOADER = Sponge.class.getClassLoader();

    @Override
    public Optional<Asset> getAsset(PluginContainer container, String name) {
        Preconditions.checkNotNull((Object)container);
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"name cannot be empty");
        URL url = CLASS_LOADER.getResource(DEFAULT_ASSET_DIR + container.getMetadata().getId() + '/' + name);
        if (url == null) {
            return Optional.empty();
        }
        return Optional.of(new SpongeAsset(container, url));
    }

    @Override
    public Optional<Asset> getAsset(String name) {
        return this.getAsset(SpongeCommon.getPlugin(), name);
    }
}

