/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.block;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.command.arguments.BlockStateArgument;
import net.minecraft.command.arguments.BlockStateParser;
import org.spongepowered.api.block.BlockState;

public class BlockStateSerializerDeserializer {
    public static String serialize(BlockState state) {
        return BlockStateParser.toString((net.minecraft.block.BlockState)((net.minecraft.block.BlockState)state));
    }

    public static Optional<BlockState> deserialize(String string) {
        String state = Objects.requireNonNull(string, "Id cannot be null!").toLowerCase(Locale.ENGLISH);
        try {
            return Optional.of((BlockState)BlockStateArgument.blockState().parse(new StringReader(state)).getState());
        }
        catch (CommandSyntaxException e) {
            return Optional.empty();
        }
    }
}

