/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.block;

import java.lang.ref.WeakReference;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedDeque;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.DataManipulator;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.api.world.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.data.persistence.NbtTranslator;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.DataUtil;
import org.spongepowered.common.world.SpongeBlockChangeFlag;
import org.spongepowered.math.vector.Vector3i;

public class SpongeBlockSnapshotBuilder
extends AbstractDataBuilder<BlockSnapshot>
implements BlockSnapshot.Builder {
    private static final Deque<SpongeBlockSnapshotBuilder> pool = new ConcurrentLinkedDeque<SpongeBlockSnapshotBuilder>();
    BlockState blockState;
    ResourceKey worldKey;
    @Nullable
    UUID creatorUniqueId;
    @Nullable
    UUID notifierUniqueId;
    Vector3i coordinates;
    @Nullable
    List<DataManipulator.Immutable> manipulators;
    @Nullable
    CompoundNBT compound;
    SpongeBlockChangeFlag flag = (SpongeBlockChangeFlag)BlockChangeFlags.ALL;
    @Nullable
    WeakReference<net.minecraft.world.server.ServerWorld> worldRef;
    private final boolean pooled;

    public static SpongeBlockSnapshotBuilder unpooled() {
        return new SpongeBlockSnapshotBuilder(false);
    }

    public static SpongeBlockSnapshotBuilder pooled() {
        SpongeBlockSnapshotBuilder builder = pool.pollFirst();
        if (builder != null) {
            return builder.reset();
        }
        return new SpongeBlockSnapshotBuilder(true);
    }

    private SpongeBlockSnapshotBuilder(boolean pooled) {
        super(BlockSnapshot.class, 1);
        this.pooled = pooled;
    }

    @Override
    public @NonNull SpongeBlockSnapshotBuilder world(@NonNull WorldProperties worldProperties) {
        this.worldKey = Objects.requireNonNull(worldProperties).getKey();
        return this;
    }

    public SpongeBlockSnapshotBuilder world(ResourceKey key) {
        this.worldKey = Objects.requireNonNull(key);
        return this;
    }

    public SpongeBlockSnapshotBuilder world(net.minecraft.world.server.ServerWorld world) {
        this.worldKey = ((ServerWorld)Objects.requireNonNull(world)).getKey();
        this.worldRef = new WeakReference<net.minecraft.world.server.ServerWorld>(world);
        return this;
    }

    @Override
    public @NonNull SpongeBlockSnapshotBuilder blockState(@NonNull BlockState blockState) {
        this.blockState = Objects.requireNonNull(blockState);
        return this;
    }

    public SpongeBlockSnapshotBuilder blockState(net.minecraft.block.BlockState blockState) {
        this.blockState = Objects.requireNonNull((BlockState)blockState);
        return this;
    }

    @Override
    public @NonNull SpongeBlockSnapshotBuilder position(@NonNull Vector3i position) {
        this.coordinates = Objects.requireNonNull(position);
        if (this.compound != null) {
            this.compound.putInt("x", position.getX());
            this.compound.putInt("y", position.getY());
            this.compound.putInt("z", position.getZ());
        }
        return this;
    }

    @Override
    public @NonNull BlockSnapshot.Builder from(@NonNull ServerLocation location) {
        return this.from(location.createSnapshot());
    }

    @Override
    public @NonNull SpongeBlockSnapshotBuilder creator(UUID uuid) {
        this.creatorUniqueId = Objects.requireNonNull(uuid);
        return this;
    }

    @Override
    public @NonNull SpongeBlockSnapshotBuilder notifier(UUID uuid) {
        this.notifierUniqueId = Objects.requireNonNull(uuid);
        return this;
    }

    @Override
    public @NonNull BlockSnapshot empty() {
        return SpongeBlockSnapshotBuilder.pooled().world(Constants.World.INVALID_WORLD_KEY).position(new Vector3i(0, 0, 0)).blockState(Blocks.AIR.getDefaultState()).build();
    }

    @Override
    public <V> @NonNull BlockSnapshot.Builder add(@NonNull Key<@NonNull ? extends Value<V>> key, @NonNull V value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        this.blockState = (BlockState)this.blockState.with(key, value).orElseThrow(() -> new IllegalArgumentException(String.format("Key %s is not supported for block state %s", key.getKey().asString(), this.blockState.toString())));
        return this;
    }

    @Override
    public @NonNull SpongeBlockSnapshotBuilder from(BlockSnapshot holder) {
        Objects.requireNonNull(holder);
        this.blockState = holder.getState();
        this.worldKey = holder.getWorld();
        if (holder.getCreator().isPresent()) {
            this.creatorUniqueId = holder.getCreator().get();
        }
        if (holder.getNotifier().isPresent()) {
            this.notifierUniqueId = holder.getNotifier().get();
        }
        this.coordinates = holder.getPosition();
        return this;
    }

    @Override
    public SpongeBlockSnapshotBuilder from(SpongeBlockSnapshot snapshot) {
        Objects.requireNonNull(snapshot);
        this.blockState = snapshot.getState();
        this.worldKey = snapshot.getWorld();
        this.worldRef = snapshot.world;
        this.compound = snapshot.compound;
        this.coordinates = snapshot.getPosition();
        this.flag = snapshot.getChangeFlag();
        return this;
    }

    @Override
    public @NonNull SpongeBlockSnapshotBuilder reset() {
        this.blockState = (BlockState)Blocks.AIR.getDefaultState();
        this.worldKey = Constants.World.INVALID_WORLD_KEY;
        this.creatorUniqueId = null;
        this.notifierUniqueId = null;
        this.coordinates = null;
        this.manipulators = null;
        this.compound = null;
        this.flag = null;
        return this;
    }

    @Override
    public @NonNull SpongeBlockSnapshot build() {
        Objects.requireNonNull(this.blockState, "BlockState cannot be null!");
        SpongeBlockSnapshot spongeBlockSnapshot = new SpongeBlockSnapshot(this);
        this.reset();
        if (this.pooled) {
            pool.push(this);
        }
        return spongeBlockSnapshot;
    }

    @Override
    protected @NonNull Optional<BlockSnapshot> buildContent(DataView container) throws InvalidDataException {
        if (!container.contains(Constants.Block.BLOCK_STATE, Queries.WORLD_KEY, Constants.Sponge.SNAPSHOT_WORLD_POSITION)) {
            return Optional.empty();
        }
        DataUtil.checkDataExists(container, Constants.Block.BLOCK_STATE);
        DataUtil.checkDataExists(container, Queries.WORLD_KEY);
        SpongeBlockSnapshotBuilder builder = SpongeBlockSnapshotBuilder.pooled();
        ResourceKey worldKey = container.getKey(Queries.WORLD_KEY).get();
        Vector3i coordinate = DataUtil.getPosition3i(container);
        Optional<String> creatorUuid = container.getString(Queries.CREATOR_ID);
        Optional<String> notifierUuid = container.getString(Queries.NOTIFIER_ID);
        BlockState blockState = container.getSerializable(Constants.Block.BLOCK_STATE, BlockState.class).get();
        builder.blockState(blockState).world(worldKey).position(coordinate);
        creatorUuid.ifPresent(s2 -> builder.creator(UUID.fromString(s2)));
        notifierUuid.ifPresent(s2 -> builder.notifier(UUID.fromString(s2)));
        container.getView(Constants.Sponge.UNSAFE_NBT).map(dataView -> NbtTranslator.getInstance().translate((DataView)dataView)).ifPresent(builder::addUnsafeCompound);
        if (container.contains(Constants.Sponge.SNAPSHOT_TILE_DATA)) {
            List<DataView> list = container.getViewList(Constants.Sponge.SNAPSHOT_TILE_DATA).get();
        }
        return Optional.of(builder.build());
    }

    public SpongeBlockSnapshotBuilder addUnsafeCompound(CompoundNBT compound) {
        Objects.requireNonNull(compound);
        this.compound = compound.copy();
        return this;
    }

    public SpongeBlockSnapshotBuilder flag(BlockChangeFlag flag) {
        this.flag = (SpongeBlockChangeFlag)flag;
        return this;
    }

    public SpongeBlockSnapshotBuilder tileEntity(TileEntity added) {
        this.compound = null;
        CompoundNBT tag = new CompoundNBT();
        added.write(tag);
        this.compound = tag;
        return this;
    }
}

