/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.brigadier.argument;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import net.minecraft.command.CommandSource;
import org.spongepowered.api.command.parameter.CommandContext;
import org.spongepowered.api.command.parameter.Parameter;
import org.spongepowered.api.command.parameter.managed.ValueCompleter;
import org.spongepowered.api.command.parameter.managed.ValueParser;
import org.spongepowered.api.command.parameter.managed.clientcompletion.ClientCompletionType;
import org.spongepowered.common.command.brigadier.SpongeImmutableArgumentReader;
import org.spongepowered.common.command.brigadier.SpongeStringReader;
import org.spongepowered.common.command.brigadier.argument.ArgumentParser;
import org.spongepowered.common.command.brigadier.argument.StandardArgumentParser;
import org.spongepowered.common.command.brigadier.context.SpongeCommandContext;
import org.spongepowered.common.command.brigadier.context.SpongeCommandContextBuilder;
import org.spongepowered.common.command.parameter.managed.clientcompletion.SpongeClientCompletionType;
import org.spongepowered.common.util.Constants;

public final class CustomArgumentParser<T>
implements ArgumentParser<T>,
SuggestionProvider<CommandSource> {
    public static final ClientCompletionType NONE_CLIENT_COMPLETION_TYPE = new SpongeClientCompletionType("none", null);
    private static final Pattern INTEGER_PATTERN = Pattern.compile("\\d+");
    private final ImmutableList<ArgumentType<?>> types;
    private final Collection<ValueParser<? extends T>> parsers;
    private final ValueCompleter completer;
    private final boolean doesNotRead;

    public CustomArgumentParser(Collection<ValueParser<? extends T>> parsers, ValueCompleter completer, boolean doesNotRead) {
        ValueParser<T> parser;
        this.parsers = parsers;
        this.completer = completer;
        boolean bl = this.doesNotRead = doesNotRead || parsers.stream().allMatch(x -> x.getClientCompletionType().contains(NONE_CLIENT_COMPLETION_TYPE));
        this.types = this.parsers.size() == 1 ? ((parser = this.parsers.iterator().next()) instanceof StandardArgumentParser ? ImmutableList.copyOf(((StandardArgumentParser)parser).getClientCompletionArgumentType()) : (this.doesNotRead ? ImmutableList.of(Constants.Command.STANDARD_STRING_ARGUMENT_TYPE) : (ImmutableList)parser.getClientCompletionType().stream().map(x -> ((SpongeClientCompletionType)x).getType()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList()))) : ImmutableList.of(Constants.Command.STANDARD_STRING_ARGUMENT_TYPE);
    }

    @Override
    public T parse(Parameter.Key<? super T> key, SpongeCommandContextBuilder contextBuilder, SpongeStringReader reader) throws CommandSyntaxException {
        ArrayList<Exception> exceptions = null;
        SpongeImmutableArgumentReader state = reader.getImmutable();
        for (ValueParser<? super T> valueParser : this.parsers) {
            CommandContext.Builder.Transaction transaction = contextBuilder.startTransaction();
            try {
                Optional<Object> value = valueParser.getValue(key, reader, contextBuilder);
                contextBuilder.commit(transaction);
                return value.orElse(null);
            }
            catch (Exception e) {
                if (exceptions == null) {
                    exceptions = new ArrayList<Exception>();
                }
                exceptions.add(e);
                reader.setState(state);
                contextBuilder.rollback(transaction);
            }
        }
        if (exceptions != null) {
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherParseException().createWithContext((ImmutableStringReader)reader, exceptions);
        }
        return null;
    }

    @Override
    public CompletableFuture<Suggestions> listSuggestions(CommandContext<?> context, SuggestionsBuilder builder) {
        for (String s2 : this.completer.complete((SpongeCommandContext)context, builder.getRemaining())) {
            if (INTEGER_PATTERN.matcher(s2).matches()) {
                try {
                    builder.suggest(Integer.parseInt(s2));
                }
                catch (NumberFormatException ex) {
                    builder.suggest(s2);
                }
                continue;
            }
            builder.suggest(s2);
        }
        return builder.buildFuture();
    }

    @Override
    public boolean doesNotRead() {
        return this.doesNotRead;
    }

    @Override
    public Collection<String> getExamples() {
        return ImmutableList.of();
    }

    @Override
    public List<ArgumentType<?>> getClientCompletionArgumentType() {
        return this.types;
    }

    public CompletableFuture<Suggestions> getSuggestions(CommandContext<CommandSource> context, SuggestionsBuilder builder) throws CommandSyntaxException {
        return this.listSuggestions(context, builder);
    }
}

