/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.brigadier.context;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.tree.CommandNode;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.ref.WeakReference;
import java.util.LinkedList;
import net.minecraft.command.CommandSource;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.command.Command;
import org.spongepowered.api.command.parameter.CommandContext;
import org.spongepowered.api.command.parameter.Parameter;
import org.spongepowered.api.command.parameter.managed.Flag;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.common.command.brigadier.context.SpongeCommandContextBuilder;
import org.spongepowered.common.command.parameter.SpongeParameterKey;

public final class SpongeCommandContextBuilderTransaction
implements CommandContext.Builder.Transaction {
    private static final LinkedList<SpongeCommandContextBuilderTransaction> TRANSACTION_POOL = new LinkedList();
    private WeakReference<SpongeCommandContextBuilder> builder;
    private SpongeCommandContextBuilder copyBuilder;
    private final Object2IntOpenHashMap<String> flagCapture = new Object2IntOpenHashMap();
    private final LinkedList<Tuple<String, ParsedArgument<CommandSource, ?>>> withArgumentCapture = new LinkedList();
    private final LinkedList<CommandSource> withSourceCapture = new LinkedList();
    private final LinkedList<Tuple<CommandNode<CommandSource>, StringRange>> withNodeCapture = new LinkedList();
    private final LinkedList<Tuple< @NonNull Parameter.Key<?>, ?>> putEntryCapture = new LinkedList();
    private final LinkedList<CommandContextBuilder<CommandSource>> withChildCapture = new LinkedList();
    private final LinkedList<Command<CommandSource>> withCommandCapture = new LinkedList();
    private Command.Parameterized currentTargetCommandCapture = null;
    private boolean isActive = false;

    public static SpongeCommandContextBuilderTransaction getTransactionFromPool(SpongeCommandContextBuilder builder) {
        SpongeCommandContextBuilderTransaction chosenTransaction = null;
        for (SpongeCommandContextBuilderTransaction transaction : TRANSACTION_POOL) {
            if (transaction.isActive() || chosenTransaction != null) continue;
            chosenTransaction = transaction.activateTransaction(builder);
        }
        if (chosenTransaction != null) {
            return chosenTransaction;
        }
        SpongeCommandContextBuilderTransaction transaction = new SpongeCommandContextBuilderTransaction().activateTransaction(builder);
        TRANSACTION_POOL.add(transaction);
        return transaction;
    }

    private SpongeCommandContextBuilderTransaction() {
    }

    private SpongeCommandContextBuilderTransaction activateTransaction(SpongeCommandContextBuilder builder) {
        if (this.isActive()) {
            throw new IllegalStateException("Transaction is already active.");
        }
        this.builder = new WeakReference<SpongeCommandContextBuilder>(builder);
        this.copyBuilder = builder.copy();
        return this;
    }

    private SpongeCommandContextBuilder getReference() {
        if (this.isActive) {
            SpongeCommandContextBuilder builder = (SpongeCommandContextBuilder)this.builder.get();
            if (builder != null) {
                return builder;
            }
            this.rollback();
        }
        throw new IllegalStateException("Transaction is not active.");
    }

    public SpongeCommandContextBuilder withArgument(String name, ParsedArgument<CommandSource, ?> argument) {
        SpongeCommandContextBuilder builder = this.getReference();
        this.withArgumentCapture.add(Tuple.of(name, argument));
        this.copyBuilder.withArgument(name, (ParsedArgument)argument);
        return builder;
    }

    public SpongeCommandContextBuilder withSource(CommandSource source) {
        SpongeCommandContextBuilder builder = this.getReference();
        this.withSourceCapture.add(source);
        this.copyBuilder.withSource(source);
        return builder;
    }

    public SpongeCommandContextBuilder withNode(CommandNode<CommandSource> node, StringRange range) {
        SpongeCommandContextBuilder builder = this.getReference();
        this.withNodeCapture.add(Tuple.of(node, range));
        this.copyBuilder.withNode(node, range);
        return builder;
    }

    public SpongeCommandContextBuilder withChild(CommandContextBuilder<CommandSource> child) {
        SpongeCommandContextBuilder builder = this.getReference();
        this.withChildCapture.add(child);
        this.copyBuilder.withChild(child);
        return builder;
    }

    public CommandContextBuilder<CommandSource> withCommand(Command<CommandSource> command) {
        SpongeCommandContextBuilder builder = this.getReference();
        this.withCommandCapture.add(command);
        this.copyBuilder.withCommand(command);
        return builder;
    }

    public <T> void putEntry( @NonNull Parameter.Key<? super T> key, @NonNull T object) {
        this.getReference();
        this.putEntryCapture.add(Tuple.of(key, object));
        this.copyBuilder.putEntry(key, object);
    }

    private <T> void putEntryAbusingGenerics(@NonNull SpongeCommandContextBuilder builderRef,  @NonNull Parameter.Key<?> key, @NonNull T object) {
        builderRef.putEntry((SpongeParameterKey)key, object);
    }

    public void addFlagInvocation(Flag flag) {
        flag.getUnprefixedAliases().forEach(x -> this.flagCapture.addTo(x, 1));
        this.copyBuilder.addFlagInvocation(flag);
    }

    public SpongeCommandContextBuilder getCopyBuilder() {
        return this.copyBuilder;
    }

    public void setCurrentTargetCommand(Command.Parameterized command) {
        this.currentTargetCommandCapture = command;
    }

    public boolean isActive() {
        if (this.isActive) {
            if (this.builder.get() != null) {
                return true;
            }
            this.rollback();
        }
        return false;
    }

    public void commit() {
        SpongeCommandContextBuilder builderRef = (SpongeCommandContextBuilder)this.builder.get();
        if (builderRef != null) {
            this.withArgumentCapture.forEach(x -> builderRef.withArgument((String)x.getFirst(), (ParsedArgument)x.getSecond()));
            this.withSourceCapture.forEach(builderRef::withSource);
            this.withNodeCapture.forEach(x -> builderRef.withNode((CommandNode<CommandSource>)((CommandNode)x.getFirst()), (StringRange)x.getSecond()));
            this.withChildCapture.forEach(builderRef::withChild);
            this.withCommandCapture.forEach(builderRef::withCommand);
            this.putEntryCapture.forEach(x -> this.putEntryAbusingGenerics(builderRef, (Parameter.Key)x.getFirst(), x.getSecond()));
            this.flagCapture.forEach(builderRef::addFlagInvocation);
            if (this.currentTargetCommandCapture != null) {
                builderRef.setCurrentTargetCommand(this.currentTargetCommandCapture);
            }
        }
        this.rollback();
    }

    public void rollback() {
        this.isActive = false;
        this.withArgumentCapture.clear();
        this.withNodeCapture.clear();
        this.withCommandCapture.clear();
        this.withChildCapture.clear();
        this.putEntryCapture.clear();
        this.flagCapture.clear();
        this.currentTargetCommandCapture = null;
        this.copyBuilder = null;
        this.builder = null;
    }
}

