/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.brigadier.tree;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Collection;
import net.minecraft.command.CommandSource;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.common.command.brigadier.context.SpongeCommandContextBuilder;
import org.spongepowered.common.command.brigadier.tree.SpongeNode;
import org.spongepowered.common.command.brigadier.tree.UnsortedNodeHolder;

public class SpongeLiteralCommandNode
extends LiteralCommandNode<CommandSource>
implements SpongeNode {
    private final UnsortedNodeHolder nodeHolder = new UnsortedNodeHolder();
    private final  @Nullable Command.Parameterized subcommandIfApplicable;

    public SpongeLiteralCommandNode(LiteralArgumentBuilder<CommandSource> argumentBuilder) {
        this(argumentBuilder, null);
    }

    public SpongeLiteralCommandNode(LiteralArgumentBuilder<CommandSource> argumentBuilder,  @Nullable Command.Parameterized associatedSubcommand) {
        super(argumentBuilder.getLiteral(), argumentBuilder.getCommand(), argumentBuilder.getRequirement(), argumentBuilder.getRedirect(), argumentBuilder.getRedirectModifier(), argumentBuilder.isFork());
        argumentBuilder.getArguments().forEach(this::addChild);
        this.subcommandIfApplicable = associatedSubcommand;
    }

    public void addChild(CommandNode<CommandSource> node) {
        super.addChild(node);
        this.nodeHolder.add(node);
    }

    @Override
    public final Collection<CommandNode<CommandSource>> getChildrenForSuggestions() {
        return this.nodeHolder.getChildrenForSuggestions();
    }

    public void parse(StringReader reader, CommandContextBuilder<CommandSource> contextBuilder) throws CommandSyntaxException {
        super.parse(reader, contextBuilder);
        if (this.subcommandIfApplicable != null && contextBuilder instanceof SpongeCommandContextBuilder) {
            ((SpongeCommandContextBuilder)contextBuilder).setCurrentTargetCommand(this.subcommandIfApplicable);
        }
    }
}

