/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.exception;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.spongepowered.api.command.exception.CommandException;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.command.brigadier.context.SpongeCommandContext;

public final class SpongeCommandSyntaxException
extends CommandSyntaxException {
    private static final Component ERROR_MESSAGE = Component.text((String)"Error running command: ", (TextColor)NamedTextColor.RED);
    private final CommandException innerException;
    private final SpongeCommandContext commandContext;

    public SpongeCommandSyntaxException(CommandException exception, SpongeCommandContext commandContext) {
        super((CommandExceptionType)new SimpleCommandExceptionType((Message)SpongeAdventure.asVanilla(exception.componentMessage())), (Message)SpongeAdventure.asVanilla(exception.componentMessage()));
        this.innerException = exception;
        this.commandContext = commandContext;
    }

    public SpongeCommandSyntaxException(CommandException exception, SpongeCommandContext commandContext, String command, int cursor) {
        super((CommandExceptionType)new SimpleCommandExceptionType((Message)SpongeAdventure.asVanilla(exception.componentMessage())), (Message)SpongeAdventure.asVanilla(exception.componentMessage()), command, cursor);
        this.innerException = exception;
        this.commandContext = commandContext;
    }

    public synchronized Throwable getCause() {
        return this.innerException;
    }

    public SpongeCommandContext getCommandContext() {
        return this.commandContext;
    }

    public Component getComponentMessage() {
        Component message = this.innerException.componentMessage();
        return ERROR_MESSAGE.append((Component)(message == null ? Component.text((String)"unknown") : message));
    }

    public String getMessage() {
        return SpongeAdventure.plain(this.getComponentMessage());
    }
}

