/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.parameter.managed.builder;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.command.parameter.managed.ValueParameter;
import org.spongepowered.api.command.parameter.managed.standard.VariableValueParameters;
import org.spongepowered.common.command.parameter.managed.standard.SpongeCatalogedElementValueParameter;

public final class SpongeCatalogedElementParameterBuilder<T extends CatalogType>
implements VariableValueParameters.CatalogedTypeBuilder<T> {
    private final Class<T> catalogType;
    private final List<String> prefixes = new ArrayList<String>();

    public SpongeCatalogedElementParameterBuilder(Class<T> catalogType) {
        this.catalogType = catalogType;
    }

    @Override
    public  @NonNull VariableValueParameters.CatalogedTypeBuilder<T> defaultNamespace(@NonNull String prefix) {
        this.prefixes.add(Objects.requireNonNull(prefix, "Prefix cannot be null!"));
        return this;
    }

    @Override
    public @NonNull ValueParameter<T> build() {
        return new SpongeCatalogedElementValueParameter<T>((List<String>)ImmutableList.copyOf(this.prefixes), this.catalogType);
    }

    @Override
    public  @NonNull VariableValueParameters.CatalogedTypeBuilder<T> reset() {
        this.prefixes.clear();
        return this;
    }
}

