/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.parameter.managed.standard;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.minecraft.command.arguments.EntityArgument;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.exception.ArgumentParseException;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.user.UserManager;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.command.brigadier.argument.CatalogedArgumentParser;
import org.spongepowered.common.command.brigadier.context.SpongeCommandContextBuilder;

public final class SpongeUserValueParameter
extends CatalogedArgumentParser<User> {
    private static final ResourceKey RESOURCE_KEY = ResourceKey.sponge("user");
    private final EntityArgument selectorArgumentType = EntityArgument.player();

    @Override
    public @NonNull ResourceKey getKey() {
        return RESOURCE_KEY;
    }

    @Override
    public CompletableFuture<Suggestions> listSuggestions(CommandContext<?> context, SuggestionsBuilder builder) {
        return super.listSuggestions(context, builder);
    }

    @Override
    public @NonNull List<String> complete(@NonNull org.spongepowered.api.command.parameter.CommandContext context, @NonNull String currentInput) {
        return Sponge.getServer().getUserManager().streamOfMatches(currentInput).filter(GameProfile::hasName).map(x -> x.getName().orElse("")).collect(Collectors.toList());
    }

    @Override
    public @NonNull Optional<? extends User> getValue( @NonNull Parameter.Key<? super User> parameterKey,  @NonNull ArgumentReader.Mutable reader,  @NonNull CommandContext.Builder context) throws ArgumentParseException {
        Optional<User> user;
        String peek = reader.peekString();
        if (peek.startsWith("@")) {
            try {
                ServerPlayer entity = (ServerPlayer)this.selectorArgumentType.parse((StringReader)reader).selectOnePlayer(((SpongeCommandContextBuilder)context).getSource());
                return Optional.of(entity.getUser());
            }
            catch (CommandSyntaxException e) {
                throw reader.createException((Component)Component.text((String)e.getContext()));
            }
        }
        UserManager userManager = SpongeCommon.getGame().getServer().getUserManager();
        try {
            UUID uuid = UUID.fromString(reader.parseString());
            user = userManager.get(uuid);
        }
        catch (Exception e) {
            user = userManager.get(peek);
        }
        if (user.isPresent()) {
            return user;
        }
        throw reader.createException((Component)Component.text((String)("Could not find user with user name \"" + peek + "\"")));
    }
}

