/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.parameter.managed.standard;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.arguments.ArgumentType;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.command.exception.ArgumentParseException;
import org.spongepowered.api.command.parameter.CommandContext;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.command.brigadier.argument.CatalogedArgumentParser;
import org.spongepowered.common.util.Constants;

public final class SpongeWorldPropertiesValueParameter
extends CatalogedArgumentParser<WorldProperties> {
    private final ResourceKey resourceKey;
    private final boolean selectAll;

    public SpongeWorldPropertiesValueParameter(boolean selectAll) {
        this.selectAll = selectAll;
        this.resourceKey = selectAll ? ResourceKey.sponge("world_properties_all") : ResourceKey.sponge("world_properties_online_only");
    }

    @Override
    public @NonNull ResourceKey getKey() {
        return this.resourceKey;
    }

    @Override
    public @NonNull List<String> complete(@NonNull CommandContext context, String currentInput) {
        return SpongeCommon.getGame().getServer().getWorldManager().getAllProperties().stream().filter(x -> this.selectAll || x.getWorld().isPresent()).map(WorldProperties::getKey).map(ResourceKey::getFormatted).filter(x -> x.startsWith(currentInput)).collect(Collectors.toList());
    }

    @Override
    public @NonNull Optional<? extends WorldProperties> getValue( @NonNull Parameter.Key<? super WorldProperties> parameterKey,  @NonNull ArgumentReader.Mutable reader, @NonNull CommandContext.Builder context) throws ArgumentParseException {
        ResourceKey resourceLocation = reader.parseResourceKey("minecraft");
        Optional<WorldProperties> worldProperties = SpongeWorldPropertiesValueParameter.getWorldProperties(resourceLocation);
        if (worldProperties.isPresent()) {
            if (this.selectAll || worldProperties.get().getWorld().isPresent()) {
                return worldProperties;
            }
            throw reader.createException((Component)Component.text((String)("World with identifier \"" + resourceLocation.toString() + "\" is not online.")));
        }
        throw reader.createException((Component)Component.text((String)("Could not find world with identifier \"" + resourceLocation.toString() + "\"")));
    }

    @Override
    public List<ArgumentType<?>> getClientCompletionArgumentType() {
        return ImmutableList.of((Object)Constants.Command.RESOURCE_LOCATION_TYPE);
    }

    static Optional<WorldProperties> getWorldProperties(ResourceKey name) {
        try {
            return SpongeCommon.getGame().getServer().getWorldManager().getProperties(name);
        }
        catch (Exception ignored) {
            return Optional.empty();
        }
    }
}

