/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.registrar;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.leangen.geantyref.TypeToken;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.minecraft.command.CommandSource;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.exception.CommandException;
import org.spongepowered.api.command.manager.CommandFailedRegistrationException;
import org.spongepowered.api.command.manager.CommandMapping;
import org.spongepowered.api.command.registrar.CommandRegistrar;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.command.brigadier.dispatcher.SpongeCommandDispatcher;
import org.spongepowered.common.command.brigadier.tree.SpongeLiteralCommandNode;
import org.spongepowered.common.command.brigadier.tree.SpongePermissionWrappedLiteralCommandNode;
import org.spongepowered.common.command.manager.SpongeCommandManager;
import org.spongepowered.common.command.registrar.BrigadierBasedRegistrar;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.plugin.PluginContainer;

public final class BrigadierCommandRegistrar
implements BrigadierBasedRegistrar,
CommandRegistrar<LiteralArgumentBuilder<CommandSource>> {
    private static final TypeToken<LiteralArgumentBuilder<CommandSource>> COMMAND_TYPE = new TypeToken<LiteralArgumentBuilder<CommandSource>>(){};
    public static final BrigadierCommandRegistrar INSTANCE = new BrigadierCommandRegistrar();
    public static final ResourceKey RESOURCE_KEY = ResourceKey.sponge("brigadier");
    private boolean hasVanillaRegistered;
    private final List<LiteralCommandNode<CommandSource>> vanilla = new ArrayList<LiteralCommandNode<CommandSource>>();
    private SpongeCommandDispatcher dispatcher = new SpongeCommandDispatcher();

    private BrigadierCommandRegistrar() {
    }

    public LiteralCommandNode<CommandSource> register(LiteralArgumentBuilder<CommandSource> command) {
        PluginContainer container = PhaseTracker.getCauseStackManager().getCurrentCause().first(PluginContainer.class).orElseThrow(() -> new IllegalStateException("Cannot register command without knowing its origin."));
        if (!this.hasVanillaRegistered && ((Launch)Launch.getInstance()).getMinecraftPlugin() == container) {
            LiteralCommandNode<CommandSource> vanillaCommand = this.applyNamespace(container, command, false);
            this.vanilla.add(vanillaCommand);
            return vanillaCommand;
        }
        return this.registerInternal(this, container, this.applyNamespace(container, command, false), new String[0], true).getSecond();
    }

    public void completeVanillaRegistration() {
        this.hasVanillaRegistered = true;
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            PluginContainer container = ((Launch)Launch.getInstance()).getMinecraftPlugin();
            frame.pushCause(container);
            for (LiteralCommandNode<CommandSource> node : this.vanilla) {
                this.registerInternal(this, container, node, new String[0], true);
            }
        }
        this.vanilla.clear();
    }

    @Override
    public TypeToken<LiteralArgumentBuilder<CommandSource>> handledType() {
        return COMMAND_TYPE;
    }

    @Override
    public @NonNull CommandMapping register(@NonNull PluginContainer container, @NonNull LiteralArgumentBuilder<CommandSource> command, @NonNull String primaryAlias, String ... secondaryAliases) throws CommandFailedRegistrationException {
        return this.register(container, command, secondaryAliases).getFirst();
    }

    public Tuple<CommandMapping, LiteralCommandNode<CommandSource>> register(PluginContainer container, LiteralArgumentBuilder<CommandSource> command, String ... secondaryAliases) {
        return this.registerInternal(this, container, this.applyNamespace(container, command, true), secondaryAliases, false);
    }

    void registerFromSpongeRegistrar(LiteralCommandNode<CommandSource> command) {
        this.dispatcher.register(command);
    }

    private Tuple<CommandMapping, LiteralCommandNode<CommandSource>> registerInternal(CommandRegistrar<?> registrar, PluginContainer container, LiteralCommandNode<CommandSource> namespacedCommand, String[] secondaryAliases, boolean allowDuplicates) {
        String requestedAlias = namespacedCommand.getLiteral();
        Optional<CommandMapping> existingMapping = SpongeCommon.getGame().getCommandManager().getCommandMapping(requestedAlias);
        if (allowDuplicates && existingMapping.isPresent()) {
            this.dispatcher.register(namespacedCommand);
            return Tuple.of(existingMapping.get(), namespacedCommand);
        }
        CommandMapping mapping = ((SpongeCommandManager)SpongeCommon.getGame().getCommandManager()).registerNamespacedAlias(registrar, container, namespacedCommand, secondaryAliases);
        this.dispatcher.register(namespacedCommand);
        for (String alias : mapping.getAllAliases()) {
            if (alias.equals(namespacedCommand.getLiteral())) continue;
            LiteralArgumentBuilder redirecting = (LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)alias).executes(namespacedCommand.getCommand())).requires(namespacedCommand.getRequirement());
            if (namespacedCommand.getRedirect() == null) {
                redirecting.redirect(namespacedCommand);
            } else {
                redirecting.forward(namespacedCommand.getRedirect(), namespacedCommand.getRedirectModifier(), namespacedCommand.isFork());
            }
            this.dispatcher.register((LiteralCommandNode<CommandSource>)redirecting.build());
        }
        return Tuple.of(mapping, namespacedCommand);
    }

    @Override
    public @NonNull CommandResult process(@NonNull CommandCause cause, @NonNull CommandMapping mapping, @NonNull String command, @NonNull String arguments) throws CommandException {
        try {
            int result = this.dispatcher.execute(this.dispatcher.parse(this.createCommandString(command, arguments), (CommandSource)cause));
            return CommandResult.builder().setResult(result).build();
        }
        catch (CommandSyntaxException e) {
            throw new CommandException((Component)Component.text((String)e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public @NonNull List<String> suggestions(@NonNull CommandCause cause, @NonNull CommandMapping mapping, @NonNull String command, @NonNull String arguments) {
        CompletableFuture suggestionsCompletableFuture = this.dispatcher.getCompletionSuggestions(this.dispatcher.parse(this.createCommandString(command, arguments), (CommandSource)cause, true));
        return ((Suggestions)suggestionsCompletableFuture.join()).getList().stream().map(Suggestion::getText).collect(Collectors.toList());
    }

    @Override
    public @NonNull Optional<Component> help(@NonNull CommandCause cause, @NonNull CommandMapping mapping) {
        CommandNode node = this.dispatcher.findNode(Collections.singletonList(mapping.getPrimaryAlias()));
        if (node != null) {
            return Optional.of(Component.text((String)this.dispatcher.getSmartUsage(node, (CommandSource)cause).toString()));
        }
        return Optional.empty();
    }

    @Override
    public boolean canExecute(CommandCause cause, CommandMapping mapping) {
        return this.dispatcher.findNode(Collections.singletonList(mapping.getPrimaryAlias())).getRequirement().test((CommandSource)cause);
    }

    public SpongeCommandDispatcher getDispatcher() {
        return this.dispatcher;
    }

    @Override
    public void reset() {
        if (SpongeCommon.getGame().getCommandManager().isResetting()) {
            this.dispatcher = new SpongeCommandDispatcher();
            this.hasVanillaRegistered = false;
        }
    }

    @Override
    public @NonNull ResourceKey getKey() {
        return RESOURCE_KEY;
    }

    private String createCommandString(String command, String argument) {
        if (argument.isEmpty()) {
            return command;
        }
        return command + " " + argument;
    }

    private LiteralCommandNode<CommandSource> applyNamespace(PluginContainer pluginContainer, LiteralArgumentBuilder<CommandSource> builder, boolean isSpongeAware) {
        if (builder.getLiteral().contains(":") || builder.getLiteral().contains(" ")) {
            throw new IllegalArgumentException("The literal must not contain a colon or a space.");
        }
        LiteralArgumentBuilder replacementBuilder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)(pluginContainer.getMetadata().getId() + ":" + builder.getLiteral())).forward(builder.getRedirect(), builder.getRedirectModifier(), builder.isFork())).executes(builder.getCommand())).requires(builder.getRequirement());
        for (CommandNode node : builder.getArguments()) {
            replacementBuilder.then(node);
        }
        if (isSpongeAware) {
            return new SpongeLiteralCommandNode((LiteralArgumentBuilder<CommandSource>)replacementBuilder);
        }
        return new SpongePermissionWrappedLiteralCommandNode((LiteralArgumentBuilder<CommandSource>)replacementBuilder);
    }
}

