/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.registrar;

import io.leangen.geantyref.TypeToken;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.Command;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.exception.CommandException;
import org.spongepowered.api.command.exception.CommandPermissionException;
import org.spongepowered.api.command.manager.CommandFailedRegistrationException;
import org.spongepowered.api.command.manager.CommandMapping;
import org.spongepowered.api.command.registrar.CommandRegistrar;
import org.spongepowered.plugin.PluginContainer;

public final class SpongeRawCommandRegistrar
implements CommandRegistrar<Command.Raw> {
    private static final TypeToken<Command.Raw> COMMAND_TYPE = TypeToken.get(Command.Raw.class);
    private static final ResourceKey CATALOG_KEY = ResourceKey.sponge("raw");
    public static final SpongeRawCommandRegistrar INSTANCE = new SpongeRawCommandRegistrar();
    private final HashMap<CommandMapping, Command.Raw> commands = new HashMap();

    @Override
    public @NonNull TypeToken< @NonNull Command.Raw> handledType() {
        return COMMAND_TYPE;
    }

    @Override
    public CommandMapping register(@NonNull PluginContainer container,  @NonNull Command.Raw command, @NonNull String primaryAlias, String ... secondaryAliases) throws CommandFailedRegistrationException {
        CommandMapping mapping = Sponge.getCommandManager().registerAlias(this, container, command.commandTree(), primaryAlias, secondaryAliases);
        this.commands.put(mapping, command);
        return mapping;
    }

    @Override
    public CommandResult process(CommandCause cause, CommandMapping mapping, String command, String arguments) throws CommandException {
        Command.Raw commandToExecute = this.commands.get(mapping);
        if (commandToExecute.canExecute(cause)) {
            return commandToExecute.process(cause, arguments);
        }
        throw new CommandPermissionException((Component)Component.text((String)("You do not have permission to run /" + command)));
    }

    @Override
    public List<String> suggestions(CommandCause cause, CommandMapping mapping, String command, String arguments) throws CommandException {
        Command.Raw commandToExecute = this.commands.get(mapping);
        if (commandToExecute.canExecute(cause)) {
            return commandToExecute.getSuggestions(cause, arguments);
        }
        return Collections.emptyList();
    }

    @Override
    public Optional<Component> help(CommandCause cause, CommandMapping mapping) {
        Command.Raw commandToExecute = this.commands.get(mapping);
        if (commandToExecute.canExecute(cause)) {
            return commandToExecute.getHelp(cause);
        }
        return Optional.empty();
    }

    @Override
    public boolean canExecute(CommandCause cause, CommandMapping mapping) {
        return this.commands.get(mapping).canExecute(cause);
    }

    @Override
    public void reset() {
        if (Sponge.getCommandManager().isResetting()) {
            this.commands.clear();
        }
    }

    @Override
    public ResourceKey getKey() {
        return CATALOG_KEY;
    }
}

