/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.selector;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.command.arguments.EntitySelectorParser;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.command.selector.Selector;
import org.spongepowered.api.command.selector.SelectorType;
import org.spongepowered.common.accessor.command.arguments.EntitySelectorParserAccessor;

public final class SpongeSelectorType
implements SelectorType {
    private final String selectorToken;
    private final ResourceKey resourceKey;
    private final Selector selector;

    public SpongeSelectorType(String selectorToken, ResourceKey resourceKey) {
        this.selectorToken = selectorToken;
        this.resourceKey = resourceKey;
        try {
            this.selector = (Selector)new EntitySelectorParser(new StringReader(this.selectorToken)).parse();
        }
        catch (CommandSyntaxException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public final @NonNull String selectorToken() {
        return this.selectorToken;
    }

    @Override
    public final @NonNull Selector toSelector() {
        return this.selector;
    }

    @Override
    public final @NonNull Selector.Builder toBuilder() {
        EntitySelectorParser parser = new EntitySelectorParser(new StringReader(this.selectorToken));
        ((EntitySelectorParserAccessor)parser).accessor$parseSelector();
        return (Selector.Builder)parser;
    }

    @Override
    public final @NonNull ResourceKey getKey() {
        return this.resourceKey;
    }
}

