/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.sponge;

import co.aikar.timings.Timings;
import java.io.File;
import java.net.URL;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.minecraft.util.math.MathHelper;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.command.Command;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.exception.CommandException;
import org.spongepowered.api.command.manager.CommandMapping;
import org.spongepowered.api.command.parameter.CommandContext;
import org.spongepowered.api.command.parameter.Parameter;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.lifecycle.RefreshGameEvent;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.command.sponge.CommandAliasesParameter;
import org.spongepowered.common.command.sponge.FilteredPluginContainerParameter;
import org.spongepowered.common.event.SpongeEventManager;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.hooks.SpongeHooks;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.common.relocate.co.aikar.timings.SpongeTimingsFactory;
import org.spongepowered.plugin.PluginContainer;
import org.spongepowered.plugin.metadata.PluginContributor;
import org.spongepowered.plugin.metadata.PluginMetadata;

public class SpongeCommand {
    protected static final String INDENT = "    ";
    protected static final String LONG_INDENT = "        ";
    protected static final Component INDENT_COMPONENT = Component.text((String)"    ");
    protected static final Component LONG_INDENT_COMPONENT = Component.text((String)"        ");
    protected static final DecimalFormat THREE_DECIMAL_DIGITS_FORMATTER = new DecimalFormat("########0.000");
    private final Parameter.Key<PluginContainer> pluginContainerKey = Parameter.key("plugin", PluginContainer.class);
    private final Parameter.Key<CommandMapping> commandMappingKey = Parameter.key("command", CommandMapping.class);
    private final Parameter.Key<WorldProperties> worldPropertiesKey = Parameter.key("world", WorldProperties.class);
    private @Nullable Component versionText = null;

    public Command.Parameterized createSpongeCommand() {
        Command.Parameterized auditCommand = Command.builder().setPermission("sponge.command.audit").setShortDescription((Component)Component.text((String)"Audit mixin classes for implementation")).setExecutor(this::auditSubcommandExecutor).build();
        Command.Parameterized chunksCommand = this.chunksSubcommand();
        Command.Parameterized heapCommand = Command.builder().setPermission("sponge.command.heap").setShortDescription((Component)Component.text((String)"Dump live JVM heap")).setExecutor(this::heapSubcommandExecutor).build();
        Command.Parameterized pluginsReloadCommand = Command.builder().setPermission("sponge.command.plugins.refresh").setShortDescription((Component)Component.text((String)"Refreshes supported plugins, typically causing plugin configuration reloads.")).parameter(Parameter.builder(PluginContainer.class).optional().parser(new FilteredPluginContainerParameter()).setKey(this.pluginContainerKey).build()).setExecutor(this::pluginsRefreshSubcommandExecutor).build();
        Command.Parameterized pluginsListCommand = Command.builder().setPermission("sponge.command.plugins.list").setShortDescription((Component)Component.text((String)"Lists all currently installed plugins.")).setExecutor(this::pluginsListSubcommand).build();
        Command.Parameterized pluginsInfoCommand = Command.builder().setPermission("sponge.command.plugins.info").setShortDescription((Component)Component.text((String)"Displays information about a specific plugin.")).parameter(Parameter.plugin().setKey(this.pluginContainerKey).build()).setExecutor(this::pluginsInfoSubcommand).build();
        Command.Parameterized pluginsCommand = Command.builder().child(pluginsReloadCommand, "refresh").child(pluginsListCommand, "list").child(pluginsInfoCommand, "info").build();
        Command.Parameterized timingsCommand = this.timingsSubcommand();
        Command.Parameterized tpsCommand = Command.builder().setPermission("sponge.command.tps").setShortDescription((Component)Component.text((String)"Provides TPS (ticks per second) data for loaded worlds.")).setExecutor(this::tpsExecutor).build();
        Command.Parameterized versionCommand = Command.builder().setPermission("sponge.command.version").setShortDescription((Component)Component.text((String)"Display Sponge's current version")).setExecutor(this::versionExecutor).build();
        Command.Parameterized whichCommand = Command.builder().setPermission("sponge.command.which").parameter(Parameter.builder(CommandMapping.class).setKey(this.commandMappingKey).parser(new CommandAliasesParameter()).build()).setShortDescription((Component)Component.text((String)"Find the plugin that owns a specific command")).setExecutor(this::whichExecutor).build();
        Command.Builder commandBuilder = Command.builder().setPermission("sponge.command.root").setExecutor(this::rootCommand).child(auditCommand, "audit").child(chunksCommand, "chunks").child(heapCommand, "heap").child(pluginsCommand, "plugins").child(timingsCommand, "timings").child(tpsCommand, "tps").child(versionCommand, "version").child(whichCommand, "which");
        this.additionalActions(commandBuilder);
        return commandBuilder.build();
    }

    protected void additionalActions(Command.Builder builder) {
    }

    private @NonNull CommandResult rootCommand(CommandContext context) {
        String subcommands;
        PluginContainer platformPlugin = ((Launch)Launch.getInstance()).getPlatformPlugin();
        PluginContainer apiPlugin = ((Launch)Launch.getInstance()).getApiPlugin();
        PluginContainer minecraftPlugin = ((Launch)Launch.getInstance()).getMinecraftPlugin();
        context.sendMessage(Identity.nil(), (Component)((TextComponent.Builder)Component.text().append(new Component[]{Component.text((String)"SpongePowered", (TextColor)NamedTextColor.YELLOW, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}).append((Component)Component.space()), Component.text((String)("Plugin Platform (running on Minecraft " + minecraftPlugin.getMetadata().getVersion() + ")")), Component.newline(), Component.text((String)((String)apiPlugin.getMetadata().getName().get() + ": " + apiPlugin.getMetadata().getVersion())), Component.newline(), Component.text((String)((String)platformPlugin.getMetadata().getName().get() + ": " + platformPlugin.getMetadata().getVersion()))})).build());
        Optional<Command.Parameterized> parameterized = context.getExecutedCommand();
        if (parameterized.isPresent() && !(subcommands = parameterized.get().subcommands().stream().filter(x -> x.getCommand().canExecute(context.getCause())).flatMap(x -> x.getAliases().stream()).collect(Collectors.joining(", "))).isEmpty()) {
            context.sendMessage(Identity.nil(), (Component)((TextComponent.Builder)Component.text().append(new Component[]{Component.newline(), Component.text((String)"Available subcommands:"), Component.newline(), Component.text((String)subcommands)})).build());
        }
        return CommandResult.success();
    }

    private @NonNull CommandResult auditSubcommandExecutor(CommandContext context) {
        SpongeCommon.getLogger().info("Starting Mixin Audit");
        ((Launch)Launch.getInstance()).auditMixins();
        return CommandResult.success();
    }

    private Command.Parameterized chunksSubcommand() {
        Command.Parameterized globalCommand = Command.builder().setExecutor(context -> {
            for (ServerWorld world : SpongeCommon.getGame().getServer().getWorldManager().getWorlds()) {
                context.sendMessage(Identity.nil(), (Component)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("World ").append((Component)Component.text((String)world.getKey().toString(), (Style)Style.style((TextDecoration)TextDecoration.BOLD)))).append(this.getChunksInfo(world))).build());
            }
            return CommandResult.success();
        }).build();
        Command.Parameterized worldCommand = Command.builder().parameter(Parameter.worldProperties().setKey(this.worldPropertiesKey).build()).setExecutor(context -> {
            WorldProperties properties = context.requireOne(this.worldPropertiesKey);
            ServerWorld world = properties.getWorld().orElseThrow(() -> new CommandException((Component)Component.text((String)("The world " + properties.getKey().toString() + " is not loaded!"))));
            context.sendMessage(Identity.nil(), (Component)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("World ").append((Component)Component.text((String)world.getKey().toString(), (Style)Style.style((TextDecoration)TextDecoration.BOLD)))).append(this.getChunksInfo(world))).build());
            return CommandResult.success();
        }).build();
        Parameter.Key<Boolean> dumpAllKey = Parameter.key("dumpAll", Boolean.class);
        Command.Parameterized dumpCommand = Command.builder().parameter(Parameter.literal(Boolean.class, Boolean.valueOf(true), "all").optional().setKey(dumpAllKey).build()).setExecutor(context -> {
            File file = new File(new File(new File("."), "chunk-dumps"), "chunk-info-" + DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss").format(LocalDateTime.now()) + "-server.txt");
            context.sendMessage(Identity.nil(), (Component)Component.text((String)("Writing chunk info to: " + file.getAbsolutePath())));
            context.sendMessage(Identity.nil(), (Component)Component.text((String)"Chunk info complete"));
            return CommandResult.success();
        }).build();
        return Command.builder().child(globalCommand, "global").child(worldCommand, "world").child(dumpCommand, "dump").setPermission("sponge.command.chunk").build();
    }

    private @NonNull CommandResult heapSubcommandExecutor(CommandContext context) {
        File file = new File(new File(new File("."), "dumps"), "heap-dump-" + DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss").format(LocalDateTime.now()) + "-server.hprof");
        SpongeCommon.getLogger().info("Writing JVM heap data to: {}", (Object)file.getAbsolutePath());
        SpongeHooks.dumpHeap(file, true);
        SpongeCommon.getLogger().info("Heap dump complete");
        return CommandResult.success();
    }

    private @NonNull CommandResult pluginsListSubcommand(CommandContext context) {
        Collection<PluginContainer> plugins = ((Launch)Launch.getInstance()).getPluginManager().getPlugins();
        context.sendMessage(Identity.nil(), this.title("Plugins (" + plugins.size() + ")"));
        for (PluginContainer specificContainer : plugins) {
            PluginMetadata metadata = specificContainer.getMetadata();
            TextComponent.Builder builder = Component.text();
            this.createShortContainerMeta((TextComponent.Builder)builder.append(INDENT_COMPONENT), metadata);
            context.sendMessage(Identity.nil(), (Component)builder.build());
        }
        return CommandResult.success();
    }

    private @NonNull CommandResult pluginsInfoSubcommand(CommandContext context) {
        PluginContainer pluginContainer = context.requireOne(this.pluginContainerKey);
        context.sendMessage(Identity.nil(), this.createContainerMeta(pluginContainer.getMetadata()));
        return CommandResult.success();
    }

    private @NonNull CommandResult pluginsRefreshSubcommandExecutor(CommandContext context) {
        Optional<PluginContainer> pluginContainer = context.getOne(this.pluginContainerKey);
        RefreshGameEvent event = SpongeEventFactory.createRefreshGameEvent(PhaseTracker.getCauseStackManager().getCurrentCause(), SpongeCommon.getGame());
        if (pluginContainer.isPresent()) {
            context.sendMessage(Identity.nil(), (Component)Component.text((String)("Sending refresh event to" + pluginContainer.get().getMetadata().getId() + ", please wait...")));
            ((SpongeEventManager)SpongeCommon.getGame().getEventManager()).post((Event)event, pluginContainer.get());
        } else {
            context.sendMessage(Identity.nil(), (Component)Component.text((String)"Sending refresh event to all plugins, please wait..."));
            SpongeCommon.getGame().getEventManager().post(event);
        }
        context.sendMessage(Identity.nil(), (Component)Component.text((String)"Completed plugin refresh."));
        return CommandResult.success();
    }

    private @NonNull Command.Parameterized timingsSubcommand() {
        return Command.builder().setPermission("sponge.command.timings").setShortDescription((Component)Component.text((String)"Manages Sponge Timings data to see performance of the server.")).child(Command.builder().setExecutor(context -> {
            if (!Timings.isTimingsEnabled()) {
                context.sendMessage(Identity.nil(), (Component)Component.text((String)"Please enable timings by typing /sponge timings on"));
                return CommandResult.empty();
            }
            Timings.reset();
            context.sendMessage(Identity.nil(), (Component)Component.text((String)"Timings reset"));
            return CommandResult.success();
        }).build(), "reset").child(Command.builder().setExecutor(context -> {
            if (!Timings.isTimingsEnabled()) {
                context.sendMessage(Identity.nil(), (Component)Component.text((String)"Please enable timings by typing /sponge timings on"));
                return CommandResult.empty();
            }
            Timings.generateReport(context.getCause().getAudience());
            return CommandResult.success();
        }).build(), "report", "paste").child(Command.builder().setExecutor(context -> {
            Timings.setTimingsEnabled(true);
            context.sendMessage(Identity.nil(), (Component)Component.text((String)"Enabled Timings & Reset"));
            return CommandResult.success();
        }).build(), "on").child(Command.builder().setExecutor(context -> {
            Timings.setTimingsEnabled(false);
            context.sendMessage(Identity.nil(), (Component)Component.text((String)"Disabled Timings"));
            return CommandResult.success();
        }).build(), "off").child(Command.builder().setExecutor(context -> {
            if (!Timings.isTimingsEnabled()) {
                context.sendMessage(Identity.nil(), (Component)Component.text((String)"Please enable timings by typing /sponge timings on"));
                return CommandResult.empty();
            }
            Timings.setVerboseTimingsEnabled(true);
            context.sendMessage(Identity.nil(), (Component)Component.text((String)"Enabled Verbose Timings"));
            return CommandResult.success();
        }).build(), "verbon").child(Command.builder().setExecutor(context -> {
            if (!Timings.isTimingsEnabled()) {
                context.sendMessage(Identity.nil(), (Component)Component.text((String)"Please enable timings by typing /sponge timings on"));
                return CommandResult.empty();
            }
            Timings.setVerboseTimingsEnabled(false);
            context.sendMessage(Identity.nil(), (Component)Component.text((String)"Disabled Verbose Timings"));
            return CommandResult.success();
        }).build(), "verboff").child(Command.builder().setExecutor(context -> {
            if (!Timings.isTimingsEnabled()) {
                context.sendMessage(Identity.nil(), (Component)Component.text((String)"Please enable timings by typing /sponge timings on"));
                return CommandResult.empty();
            }
            context.sendMessage(Identity.nil(), (Component)Component.text((String)("Timings cost: " + SpongeTimingsFactory.getCost())));
            return CommandResult.success();
        }).build(), "cost").build();
    }

    private CommandResult tpsExecutor(CommandContext context) {
        ArrayList<Component> tps = new ArrayList<Component>();
        tps.add((Component)this.appendTickTime(SpongeCommon.getServer().tickTimeArray, Component.text().content("Overall TPS: ")).build());
        SpongeCommon.getGame().getServiceProvider().paginationService().builder().contents(tps).title((Component)Component.text((String)"Server TPS", (TextColor)NamedTextColor.WHITE)).padding((Component)Component.text((String)"-", (TextColor)NamedTextColor.WHITE)).sendTo(context.getCause().getAudience());
        return CommandResult.success();
    }

    private TextComponent.Builder appendTickTime(long[] tickTimes, TextComponent.Builder builder) {
        double averageTickTime = MathHelper.average((long[])tickTimes) * 1.0E-6;
        ((TextComponent.Builder)((TextComponent.Builder)builder.append((Component)Component.text((String)THREE_DECIMAL_DIGITS_FORMATTER.format(Math.min(1000.0 / averageTickTime, 20.0)), (TextColor)NamedTextColor.LIGHT_PURPLE))).append((Component)Component.text((String)", Mean: "))).append((Component)Component.text((String)(THREE_DECIMAL_DIGITS_FORMATTER.format(averageTickTime) + "ms"), (TextColor)NamedTextColor.RED));
        return builder;
    }

    private @NonNull CommandResult versionExecutor(CommandContext context) {
        if (this.versionText == null) {
            PluginContainer platformPlugin = ((Launch)Launch.getInstance()).getPlatformPlugin();
            TextComponent.Builder builder = (TextComponent.Builder)Component.text().append((Component)Component.text((String)((String)platformPlugin.getMetadata().getName().get()), (Style)Style.style((TextColor)NamedTextColor.YELLOW, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD})));
            TextComponent colon = Component.text((String)": ", (TextColor)NamedTextColor.GRAY);
            for (PluginContainer container : ((Launch)Launch.getInstance()).getLauncherPlugins()) {
                PluginMetadata metadata = container.getMetadata();
                Component[] componentArray = new Component[5];
                componentArray[0] = Component.newline();
                componentArray[1] = INDENT_COMPONENT;
                componentArray[2] = Component.text((String)metadata.getName().orElseGet(() -> ((PluginMetadata)metadata).getId()), (TextColor)NamedTextColor.GRAY);
                componentArray[3] = colon;
                componentArray[4] = Component.text((String)container.getMetadata().getVersion());
                builder.append(componentArray);
            }
            String arch = System.getProperty("sun.arch.data.model");
            String javaArch = arch != null ? arch + "-bit" : "UNKNOWN";
            String javaVendor = System.getProperty("java.vendor");
            String javaVersion = System.getProperty("java.version");
            String osName = System.getProperty("os.name");
            String osVersion = System.getProperty("os.version");
            String osArch = System.getProperty("os.arch");
            builder.append(new Component[]{Component.newline(), INDENT_COMPONENT, Component.text((String)"JVM", (TextColor)NamedTextColor.GRAY), colon, Component.text((String)(javaVersion + "/" + javaArch + " (" + javaVendor + ")")), Component.newline(), INDENT_COMPONENT, Component.text((String)"OS", (TextColor)NamedTextColor.GRAY), colon, Component.text((String)(osName + "/" + osVersion + " (" + osArch + ")"))});
            this.versionText = builder.build();
        }
        context.sendMessage(Identity.nil(), this.versionText);
        return CommandResult.success();
    }

    private @NonNull CommandResult whichExecutor(CommandContext context) {
        CommandMapping mapping = context.requireOne(this.commandMappingKey);
        context.sendMessage(Identity.nil(), (Component)((TextComponent.Builder)Component.text().append(new Component[]{this.title("Aliases: "), Component.join((ComponentLike)Component.text((String)", "), (Iterable)mapping.getAllAliases().stream().map(x -> Component.text((String)x, (TextColor)NamedTextColor.YELLOW)).collect(Collectors.toList())), Component.newline(), this.title("Owned by: "), this.hl(mapping.getPlugin().getMetadata().getName().orElseGet(() -> mapping.getPlugin().getMetadata().getId()))})).build());
        return CommandResult.success();
    }

    protected Component getChunksInfo(ServerWorld worldserver) {
        if (((WorldBridge)((Object)worldserver)).bridge$isFake() || worldserver.getWorldStorage().getWorldProperties() == null) {
            return ((TextComponent.Builder)Component.text().append(new Component[]{Component.newline(), Component.text((String)"Fake world")})).build();
        }
        return ((TextComponent.Builder)Component.text().append(new Component[]{Component.newline(), Component.text((String)"chunk stuff here")})).build();
    }

    protected Component key(String text) {
        return Component.text((String)text, (TextColor)NamedTextColor.GOLD);
    }

    protected Component value(String text) {
        return Component.text((String)text, (TextColor)NamedTextColor.GRAY);
    }

    private Component title(String title) {
        return Component.text((String)title, (TextColor)NamedTextColor.GREEN);
    }

    private Component hl(String toHighlight) {
        return Component.text((String)toHighlight, (TextColor)NamedTextColor.DARK_GREEN);
    }

    private void appendPluginMeta(TextComponent.Builder builder, String key, String value) {
        this.appendPluginMeta(builder, key, (Component)Component.text((String)value));
    }

    private void appendPluginMeta(TextComponent.Builder builder, String key, URL value) {
        String url = value.toString();
        this.appendPluginMeta(builder, key, (Component)((TextComponent.Builder)((TextComponent.Builder)Component.text().content(url).clickEvent(ClickEvent.openUrl((String)url))).decoration(TextDecoration.UNDERLINED, true)).build());
    }

    private void appendPluginMeta(TextComponent.Builder builder, String key, Component value) {
        ((TextComponent.Builder)((TextComponent.Builder)builder.append((Component)Component.newline())).append(new Component[0])).append(new Component[]{INDENT_COMPONENT, this.title(key + ": "), value});
    }

    private void createShortContainerMeta(TextComponent.Builder builder, PluginMetadata pluginMetadata) {
        builder.append(this.title(pluginMetadata.getName().orElse(pluginMetadata.getId())));
        builder.append((Component)Component.text((String)(" v" + pluginMetadata.getVersion())));
    }

    private Component createContainerMeta(PluginMetadata pluginMetadata) {
        TextComponent.Builder builder = Component.text();
        this.createShortContainerMeta(builder, pluginMetadata);
        this.appendPluginMeta(builder, "ID", pluginMetadata.getId());
        pluginMetadata.getDescription().ifPresent(x -> this.appendPluginMeta(builder, "Description", (String)x));
        pluginMetadata.getLinks().getHomepage().ifPresent(x -> this.appendPluginMeta(builder, "Homepage", (URL)x));
        pluginMetadata.getLinks().getIssues().ifPresent(x -> this.appendPluginMeta(builder, "Issues", (URL)x));
        pluginMetadata.getLinks().getSource().ifPresent(x -> this.appendPluginMeta(builder, "Source", (URL)x));
        List contributors = pluginMetadata.getContributors();
        if (!contributors.isEmpty()) {
            ((TextComponent.Builder)((TextComponent.Builder)builder.append((Component)Component.newline())).append(INDENT_COMPONENT)).append(this.title("Contributors:"));
            for (PluginContributor contributor : contributors) {
                ((TextComponent.Builder)((TextComponent.Builder)builder.append((Component)Component.newline())).append(LONG_INDENT_COMPONENT)).append((Component)Component.text((String)contributor.getName()));
                contributor.getDescription().ifPresent(x -> {
                    TextComponent.Builder cfr_ignored_0 = (TextComponent.Builder)builder.append((Component)Component.text((String)(" (" + x + ")")));
                });
            }
        }
        this.appendPluginMeta(builder, "Main class", pluginMetadata.getMainClass());
        return builder.build();
    }
}

