/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.config;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.world.dimension.DimensionType;
import org.spongepowered.api.world.dimension.DimensionTypes;
import org.spongepowered.common.applaunch.config.core.ConfigHandle;
import org.spongepowered.common.applaunch.config.core.SpongeConfigs;
import org.spongepowered.common.bridge.world.storage.WorldInfoBridge;
import org.spongepowered.common.config.customdata.CustomDataConfig;
import org.spongepowered.common.config.inheritable.GlobalConfig;
import org.spongepowered.common.config.inheritable.InheritableConfigHandle;
import org.spongepowered.common.config.inheritable.WorldConfig;
import org.spongepowered.common.config.tracker.TrackerConfig;
import org.spongepowered.common.world.server.SpongeWorldManager;
import org.spongepowered.configurate.ConfigurateException;

public final class SpongeGameConfigs {
    static final Logger LOGGER = LogManager.getLogger();
    private static final Lock initLock = new ReentrantLock();
    private static ConfigHandle<TrackerConfig> trackerConfigAdapter;
    private static ConfigHandle<CustomDataConfig> customDataConfigAdapter;
    private static volatile InheritableConfigHandle<GlobalConfig> global;

    private SpongeGameConfigs() {
    }

    public static ConfigHandle<CustomDataConfig> getCustomData() {
        if (customDataConfigAdapter == null) {
            customDataConfigAdapter = SpongeConfigs.create(new CustomDataConfig(), "custom_data.conf");
        }
        return customDataConfigAdapter;
    }

    public static ConfigHandle<TrackerConfig> getTracker() {
        if (trackerConfigAdapter == null) {
            trackerConfigAdapter = SpongeConfigs.create(new TrackerConfig(), "tracker.conf");
        }
        return trackerConfigAdapter;
    }

    public static InheritableConfigHandle<WorldConfig> getForWorld(org.spongepowered.api.world.World<?> spongeWorld) {
        return SpongeGameConfigs.getForWorld((World)spongeWorld);
    }

    public static InheritableConfigHandle<WorldConfig> getForWorld(World mcWorld) {
        return ((WorldInfoBridge)mcWorld.getWorldInfo()).bridge$getConfigAdapter();
    }

    public static boolean doesWorldConfigExist(ResourceKey world) {
        Path configPath = SpongeConfigs.getDirectory().resolve(Paths.get("worlds", world.getNamespace(), world.getValue() + ".conf"));
        return Files.exists(configPath, new LinkOption[0]);
    }

    public static InheritableConfigHandle<WorldConfig> createWorld(@Nullable DimensionType legacyType, ResourceKey world) {
        Path legacyPath;
        String legacyName;
        Path configPath = SpongeConfigs.getDirectory().resolve(Paths.get("worlds", world.getNamespace(), world.getValue() + ".conf"));
        if (legacyType != null && (legacyName = SpongeGameConfigs.getLegacyWorldName(world)) != null && (legacyPath = SpongeConfigs.getDirectory().resolve(Paths.get("worlds", legacyType.getKey().getNamespace(), SpongeGameConfigs.getLegacyValue(legacyType.getKey()), legacyName, "world.conf"))).toFile().isFile() && !configPath.toFile().isFile()) {
            try {
                Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
                Files.move(legacyPath, configPath, new CopyOption[0]);
                Path legacyParent = legacyPath.getParent();
                try (DirectoryStream<Path> str = Files.newDirectoryStream(legacyParent);){
                    if (!str.iterator().hasNext()) {
                        Files.delete(legacyParent);
                    }
                }
            }
            catch (IOException ex) {
                LOGGER.error("Unable to migrate config for world {} from legacy location {}", (Object)world, (Object)legacyPath, (Object)ex);
            }
        }
        try {
            InheritableConfigHandle<WorldConfig> config = new InheritableConfigHandle<WorldConfig>(new WorldConfig(), SpongeConfigs.createLoader(configPath), SpongeGameConfigs.getGlobalInheritable());
            config.load();
            return config;
        }
        catch (ConfigurateException ex) {
            LOGGER.error("Unable to load configuration for world {}. Sponge will use a fallback configuration with default values that will not save.", (Object)world, (Object)ex);
            return SpongeGameConfigs.createDetached();
        }
    }

    private static String getLegacyValue(ResourceKey dimensionType) {
        if (dimensionType.equals(DimensionTypes.THE_NETHER.get().getKey())) {
            return "nether";
        }
        return dimensionType.getValue();
    }

    private static @Nullable String getLegacyWorldName(ResourceKey world) {
        if (world.equals(SpongeWorldManager.VANILLA_OVERWORLD)) {
            return "world";
        }
        if (world.equals(SpongeWorldManager.VANILLA_THE_END)) {
            return "DIM1";
        }
        if (world.equals(SpongeWorldManager.VANILLA_THE_NETHER)) {
            return "DIM-1";
        }
        return null;
    }

    private static InheritableConfigHandle<GlobalConfig> getGlobalInheritable() {
        if (global == null) {
            initLock.lock();
            try {
                if (global == null) {
                    try {
                        global = new InheritableConfigHandle<GlobalConfig>(new GlobalConfig(), SpongeConfigs.createLoader(SpongeConfigs.getDirectory().resolve("global.conf")), null);
                        global.load();
                    }
                    catch (ConfigurateException e) {
                        LOGGER.error("Unable to load global world configuration in {}. Sponge will run with default settings", (Object)"global.conf", (Object)e);
                        global = new InheritableConfigHandle<GlobalConfig>(new GlobalConfig(), null);
                    }
                }
            }
            finally {
                initLock.unlock();
            }
        }
        return global;
    }

    public static InheritableConfigHandle<WorldConfig> createDetached() {
        return new InheritableConfigHandle<WorldConfig>(new WorldConfig(), SpongeGameConfigs.getGlobalInheritable());
    }
}

