/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.config.inheritable;

import java.util.HashMap;
import java.util.Map;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.meta.Comment;
import org.spongepowered.configurate.objectmapping.meta.Setting;

@ConfigSerializable
public final class CollisionModCategory {
    @Setting(value="enabled")
    @Comment(value="If 'false', entity collision rules for this mod will be ignored.")
    private boolean enabled = true;
    @Setting(value="defaults")
    @Comment(value="Default maximum collisions used for all entities/blocks unless overridden.")
    private Map<String, Integer> defaultMaxCollisions = new HashMap<String, Integer>();
    @Setting(value="blocks")
    private Map<String, Integer> blockList = new HashMap<String, Integer>();
    @Setting(value="entities")
    private Map<String, Integer> entityList = new HashMap<String, Integer>();

    public CollisionModCategory() {
        this.defaultMaxCollisions.put("blocks", 8);
        this.defaultMaxCollisions.put("entities", 8);
    }

    public CollisionModCategory(String modId) {
        if (modId.equals("minecraft")) {
            this.blockList.put("detector_rail", 1);
            this.blockList.put("heavy_weighted_pressure_plate", 150);
            this.blockList.put("light_weighted_pressure_plate", 15);
            this.blockList.put("mob_spawner", -1);
            this.blockList.put("stone_pressure_plate", 1);
            this.blockList.put("wooden_button", 1);
            this.blockList.put("wooden_pressure_plate", 1);
            this.entityList.put("thrownpotion", -1);
        } else if (modId.equals("botania")) {
            this.entityList.put("spark", -1);
            this.entityList.put("corporeaspark", -1);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Map<String, Integer> getDefaultMaxCollisions() {
        return this.defaultMaxCollisions;
    }

    public Map<String, Integer> getBlockList() {
        return this.blockList;
    }

    public Map<String, Integer> getEntityList() {
        return this.entityList;
    }
}

