/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.config.inheritable;

import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.meta.Comment;
import org.spongepowered.configurate.objectmapping.meta.Setting;

@ConfigSerializable
public final class EntityCategory {
    @Setting
    @Comment(value="Maximum size of an entity's bounding box before removing it. Set to 0 to disable")
    private int maxBoundingBoxSize = 1000;
    @Setting(value="collision-warn-size")
    @Comment(value="Number of colliding entities in one spot before logging a warning. Set to 0 to disable")
    private int maxCollisionSize = 200;
    @Setting
    @Comment(value="Square of the maximum speed of an entity before removing it. Set to 0 to disable")
    private int maxSpeed = 100;
    @Setting
    @Comment(value="Controls the time in ticks for when an item despawns.")
    private int itemDespawnRate = 6000;
    @Setting
    @Comment(value="Number of ticks before the fake player entry of a human is removed from the tab list (range of 0 to 100 ticks).")
    private int humanPlayerListRemoveDelay = 10;
    @Setting(value="entity-painting-respawn-delay")
    @Comment(value="Number of ticks before a painting is respawned on clients when their art is changed")
    private int paintingRespawnDelaly = 2;
    @Setting(value="living-soft-despawn-range")
    @Comment(value="The lower bounded range where living entities near a player may potentially despawn")
    private int softDespawnRange = 32;
    @Setting(value="living-hard-despawn-range")
    @Comment(value="The upper bounded range where living entities farther from a player will likely despawn")
    private int hardDespawnRange = 128;
    @Setting(value="living-soft-despawn-minimum-life")
    @Comment(value="The amount of seconds before a living entity between the soft and hard despawn ranges from a player to be considered for despawning")
    private int minimumLife = 30;

    public int getMaxSpeed() {
        return this.maxSpeed;
    }

    public void setMaxSpeed(int maxSpeed) {
        this.maxSpeed = maxSpeed;
    }

    public int getMaxBoundingBoxSize() {
        return this.maxBoundingBoxSize;
    }

    public void setMaxBoundingBoxSize(int maxBoundingBoxSize) {
        this.maxBoundingBoxSize = maxBoundingBoxSize;
    }

    public int getMaxCollisionSize() {
        return this.maxCollisionSize;
    }

    public void setMaxCollisionSize(int maxCollisionSize) {
        this.maxCollisionSize = maxCollisionSize;
    }

    public int getItemDespawnRate() {
        return this.itemDespawnRate;
    }

    public void setItemDespawnRate(int itemDespawnRate) {
        this.itemDespawnRate = itemDespawnRate;
    }

    public int getHumanPlayerListRemoveDelay() {
        return this.humanPlayerListRemoveDelay;
    }

    public void setHumanPlayerListRemoveDelay(int delay) {
        this.humanPlayerListRemoveDelay = Math.max(0, Math.min(delay, 100));
    }

    public int getPaintingRespawnDelay() {
        return this.paintingRespawnDelaly;
    }

    public void setPaintingRespawnDelaly(int paintingRespawnDelaly) {
        this.paintingRespawnDelaly = Math.min(paintingRespawnDelaly, 1);
    }

    public int getSoftDespawnRange() {
        return this.softDespawnRange;
    }

    public void setSoftDespawnRange(int softDespawnRange) {
        this.softDespawnRange = Math.min(softDespawnRange, 10);
    }

    public int getHardDespawnRange() {
        return this.hardDespawnRange;
    }

    public void setHardDespawnRange(int hardDespawnRange) {
        this.hardDespawnRange = Math.min(hardDespawnRange, 10);
    }

    public int getMinimumLife() {
        return this.minimumLife;
    }

    public void setMinimumLife(int minimumLife) {
        this.minimumLife = Math.min(minimumLife, 20);
    }
}

