/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.builder.util.weighted;

import java.util.Optional;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.util.weighted.VariableAmount;

public class OptionalVarianceBuilder
extends AbstractDataBuilder<VariableAmount.OptionalAmount> {
    public OptionalVarianceBuilder() {
        super(VariableAmount.OptionalAmount.class, 1);
    }

    @Override
    protected Optional<VariableAmount.OptionalAmount> buildContent(DataView container) throws InvalidDataException {
        if (!container.contains(Queries.VARIABLE_BASE, Queries.VARIABLE_VARIANCE, Queries.VARIABLE_CHANCE)) {
            return Optional.empty();
        }
        double base = container.getInt(Queries.VARIABLE_BASE).get().intValue();
        double chance = container.getDouble(Queries.VARIABLE_CHANCE).get();
        VariableAmount amount = container.getSerializable(Queries.VARIABLE_VARIANCE, VariableAmount.class).get();
        return Optional.of((VariableAmount.OptionalAmount)VariableAmount.baseWithOptionalVariance(base, amount, chance));
    }
}

