/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.copy;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.spongepowered.common.data.copy.Copyable;

public class CopyHelper {
    public static <T> T copy(T value) {
        if (value instanceof Copyable) {
            return ((Copyable)value).copy();
        }
        if (value instanceof Map) {
            return (T)CopyHelper.copyMap((Map)value);
        }
        if (value instanceof List) {
            return (T)CopyHelper.copyList((List)value);
        }
        return value;
    }

    public static <L extends List<E>, E> L copyList(L list) {
        Cloneable copy;
        boolean copyElements;
        if (list.isEmpty()) {
            copyElements = false;
        } else {
            E first = list.get(0);
            boolean bl = copyElements = CopyHelper.copy(first) == first;
        }
        if (list instanceof ImmutableList) {
            if (copyElements) {
                return (L)((List)list.stream().map(CopyHelper::copy).collect(ImmutableList.toImmutableList()));
            }
            return list;
        }
        Class<?> type = list.getClass();
        if (type == LinkedList.class) {
            if (copyElements) {
                copy = new LinkedList();
                list.forEach(element -> copy.add(CopyHelper.copy(element)));
            } else {
                copy = new LinkedList(list);
            }
        } else if (type == CopyOnWriteArrayList.class) {
            copy = copyElements ? new CopyOnWriteArrayList(list.stream().map(CopyHelper::copy).collect(Collectors.toList())) : new CopyOnWriteArrayList(list);
        } else if (copyElements) {
            copy = new ArrayList(list.size());
            list.forEach(element -> copy.add(CopyHelper.copy(element)));
        } else {
            copy = new ArrayList(list);
        }
        return (L)copy;
    }

    public static <M extends Map<K, V>, K, V> M copyMap(M map) {
        HashMap copy;
        boolean copyEntries;
        if (map instanceof Copyable) {
            return (M)((Map)((Copyable)((Object)map)).copy());
        }
        if (map.isEmpty()) {
            copyEntries = false;
        } else {
            Map.Entry<K, V> firstEntry = map.entrySet().iterator().next();
            boolean bl = copyEntries = CopyHelper.copy(firstEntry.getKey()) == firstEntry.getKey() || CopyHelper.copy(firstEntry.getValue()) == firstEntry.getValue();
        }
        if (map instanceof ImmutableMap) {
            if (copyEntries) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                map.forEach((key, value) -> builder.put(CopyHelper.copy(key), CopyHelper.copy(value)));
                return (M)builder.build();
            }
            return map;
        }
        Class<?> type = map.getClass();
        if (type == HashMap.class) {
            if (copyEntries) {
                copy = new HashMap();
                map.forEach((key, value) -> copy.put(CopyHelper.copy(key), CopyHelper.copy(value)));
            } else {
                copy = new HashMap(map);
            }
        } else if (copyEntries) {
            copy = new LinkedHashMap();
            map.forEach((key, value) -> copy.put(CopyHelper.copy(key), CopyHelper.copy(value)));
        } else {
            copy = new LinkedHashMap(map);
        }
        return (M)copy;
    }

    public static <T> Supplier<T> createSupplier(T value) {
        Object copy = CopyHelper.copy(value);
        if (copy == value) {
            return () -> value;
        }
        return () -> CopyHelper.copy(copy);
    }
}

