/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.fixer.entity;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import net.minecraft.util.datafix.TypeReferences;
import org.spongepowered.common.data.fixer.world.SpongeLevelFixer;

public class EntityTrackedUser
extends DataFix {
    public EntityTrackedUser(Schema outputSchema, boolean changesType) {
        super(outputSchema, changesType);
    }

    protected TypeRewriteRule makeRule() {
        Type entityType = this.getInputSchema().getType(TypeReferences.ENTITY);
        Type forgeDataType = entityType.findFieldType("ForgeData");
        Type spongeDataType = forgeDataType.findFieldType("SpongeData");
        OpticFinder forgeDataFinder = DSL.fieldFinder((String)"ForgeData", (Type)forgeDataType);
        OpticFinder spongeDataFinder = DSL.fieldFinder((String)"SpongeData", (Type)spongeDataType);
        return TypeRewriteRule.seq((TypeRewriteRule)this.fixTracked(forgeDataFinder, spongeDataFinder, spongeDataType, "Creator"), (TypeRewriteRule)this.fixTracked(forgeDataFinder, spongeDataFinder, spongeDataType, "Notifier"));
    }

    private TypeRewriteRule fixTracked(OpticFinder<?> forgeDataFinder, OpticFinder<?> spongeDataFinder, Type<?> spongeDataType, String name) {
        Type trackedType = spongeDataType.findFieldType(name);
        OpticFinder trackedFinder = DSL.fieldFinder((String)name, (Type)trackedType);
        return this.fixTypeEverywhereTyped("Entity" + name + "UserFix", this.getInputSchema().getType(TypeReferences.ENTITY), type -> {
            Typed forge = type.getTyped(forgeDataFinder);
            Typed sponge = forge.getTyped(spongeDataFinder);
            return SpongeLevelFixer.updateUUIDIn(sponge.getTyped(trackedFinder));
        });
    }
}

