/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.holder;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataProvider;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.common.data.SpongeDataManager;

public interface SpongeDataHolder
extends DataHolder {
    default public <V extends Value<E>, E> DataProvider<V, E> getProviderFor(Key<V> key) {
        return SpongeDataManager.getProviderRegistry().getProvider(key, this.delegateDataHolder().getClass());
    }

    default public DataHolder delegateDataHolder() {
        return this;
    }

    default public Collection<DataProvider<?, ?>> getAllProviders() {
        return SpongeDataManager.getProviderRegistry().getAllProviders(this.delegateDataHolder().getClass());
    }

    @Override
    default public boolean supports(Key<?> key) {
        return this.getProviderFor(key).isSupported(this.delegateDataHolder());
    }

    @Override
    default public <E> Optional<E> get(Key<? extends Value<E>> key) {
        return this.getProviderFor(key).get(this.delegateDataHolder());
    }

    @Override
    default public <E, V extends Value<E>> Optional<V> getValue(Key<V> key) {
        return this.getProviderFor(key).getValue(this.delegateDataHolder());
    }

    default public Map<Key<?>, Object> getMappedValues() {
        HashMap map = new HashMap();
        for (DataProvider<?, ?> provider : this.getAllProviders()) {
            provider.get(this.delegateDataHolder()).ifPresent(value -> map.put(provider.getKey(), value));
        }
        return map;
    }

    @Override
    default public Set<Key<?>> getKeys() {
        return (Set)this.getAllProviders().stream().map(provider -> provider.get(this.delegateDataHolder()).map(v -> provider.getKey()).orElse(null)).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    default public Set<Value.Immutable<?>> getValues() {
        return (Set)this.getAllProviders().stream().map(provider -> provider.getValue(this.delegateDataHolder()).map(Value::asImmutable).orElse(null)).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
    }
}

