/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.persistence;

import java.lang.reflect.Type;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.persistence.DataTranslator;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.common.data.persistence.ConfigurateTranslator;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;

public class DataTranslatorTypeSerializer<T>
implements TypeSerializer<T> {
    private final DataTranslator<T> dataTranslator;

    private DataTranslatorTypeSerializer(DataTranslator<T> dataTranslator) {
        this.dataTranslator = Objects.requireNonNull(dataTranslator, "dataTranslator");
    }

    @Override
    public T deserialize(Type type, ConfigurationNode value) throws SerializationException {
        try {
            return this.dataTranslator.translate(ConfigurateTranslator.instance().translate(value));
        }
        catch (InvalidDataException e) {
            throw new SerializationException(e);
        }
    }

    @Override
    public void serialize(Type type, @Nullable T obj, ConfigurationNode value) throws SerializationException {
        if (obj == null) {
            value.set(null);
        }
        try {
            ConfigurateTranslator.instance().translateDataToNode(value, this.dataTranslator.translate(obj));
        }
        catch (InvalidDataException e) {
            throw new SerializationException(value, type, "Could not serialize. Data was invalid.", e);
        }
    }

    public static <T> DataTranslatorTypeSerializer<T> from(DataTranslator<T> dataTranslator) {
        return new DataTranslatorTypeSerializer<T>(dataTranslator);
    }
}

