/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.persistence;

import com.google.common.base.Preconditions;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataQuery;
import org.spongepowered.api.data.persistence.DataView;

public final class DataViewJsonWriter
extends JsonWriter {
    private static final Writer UNWRITABLE_WRITER = new Writer(){

        @Override
        public void write(char[] buffer, int offset, int counter) {
            throw new AssertionError();
        }

        @Override
        public void flush() throws IOException {
            throw new AssertionError();
        }

        @Override
        public void close() throws IOException {
            throw new AssertionError();
        }
    };
    private final List<Object> stack = new ArrayList<Object>();
    @Nullable
    private DataQuery pendingKey;
    private DataContainer result = DataContainer.createNew(DataView.SafetyMode.NO_DATA_CLONED);

    public DataViewJsonWriter() {
        super(UNWRITABLE_WRITER);
    }

    public DataContainer getResult() throws IOException {
        this.close();
        return this.result;
    }

    private Object peek() {
        return this.stack.get(this.stack.size() - 1);
    }

    private Object pop() {
        return this.stack.remove(this.stack.size() - 1);
    }

    private void put(@Nullable Object value) {
        if (this.pendingKey != null) {
            ((DataView)this.peek()).set(this.pendingKey, value);
            this.pendingKey = null;
        } else {
            ((List)this.peek()).add(value);
        }
    }

    @Override
    public JsonWriter beginArray() {
        ArrayList list = new ArrayList();
        this.put(list);
        this.stack.add(list);
        return this;
    }

    @Override
    public JsonWriter endArray() {
        Preconditions.checkState((!this.stack.isEmpty() && this.pendingKey == null && this.pop() instanceof List ? 1 : 0) != 0);
        return this;
    }

    @Override
    public JsonWriter beginObject() {
        if (this.stack.isEmpty()) {
            this.stack.add(this.result);
            return this;
        }
        Object parent = this.peek();
        if (parent instanceof DataView) {
            Preconditions.checkState((this.pendingKey != null ? 1 : 0) != 0);
            ((DataView)parent).createView(this.pendingKey);
            this.pendingKey = null;
            return this;
        }
        this.put(DataContainer.createNew(DataView.SafetyMode.NO_DATA_CLONED));
        return this;
    }

    @Override
    public JsonWriter endObject() {
        Preconditions.checkState((!this.stack.isEmpty() && this.pendingKey == null && this.pop() instanceof DataView ? 1 : 0) != 0);
        return this;
    }

    @Override
    public JsonWriter name(String name) {
        Preconditions.checkState((!this.stack.isEmpty() && this.pendingKey == null && this.peek() instanceof DataView ? 1 : 0) != 0);
        this.pendingKey = DataQuery.of(name);
        return this;
    }

    @Override
    public JsonWriter value(String value) {
        this.put(value);
        return this;
    }

    @Override
    public JsonWriter nullValue() {
        this.put(null);
        return this;
    }

    @Override
    public JsonWriter value(boolean value) {
        this.put(value);
        return this;
    }

    @Override
    public JsonWriter value(double value) {
        this.put(value);
        return this;
    }

    @Override
    public JsonWriter value(long value) {
        this.put(value);
        return this;
    }

    @Override
    public JsonWriter value(Number value) {
        this.put(value);
        return this;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws IOException {
        if (!this.stack.isEmpty()) {
            throw new IOException("Incomplete document");
        }
    }
}

