/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.persistence;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.leangen.geantyref.TypeToken;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.ShortNBT;
import net.minecraft.nbt.StringNBT;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataQuery;
import org.spongepowered.api.data.persistence.DataSerializable;
import org.spongepowered.api.data.persistence.DataTranslator;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.common.SpongeCatalogType;
import org.spongepowered.common.accessor.nbt.LongArrayNBTAccessor;

public final class NbtTranslator
extends SpongeCatalogType
implements DataTranslator<CompoundNBT> {
    private static final NbtTranslator instance = new NbtTranslator();
    private static final TypeToken<CompoundNBT> TOKEN = TypeToken.get(CompoundNBT.class);
    public static final String BOOLEAN_IDENTIFIER = "$Boolean";

    public static NbtTranslator getInstance() {
        return instance;
    }

    private NbtTranslator() {
        super(ResourceKey.sponge("nbt"));
    }

    private static CompoundNBT containerToCompound(DataView container) {
        Preconditions.checkNotNull((Object)container);
        CompoundNBT compound = new CompoundNBT();
        NbtTranslator.containerToCompound(container, compound);
        return compound;
    }

    private static void containerToCompound(DataView container, CompoundNBT compound) {
        Preconditions.checkNotNull((Object)container);
        Preconditions.checkNotNull((Object)compound);
        for (Map.Entry<DataQuery, Object> entry : container.getValues(false).entrySet()) {
            Object value = entry.getValue();
            String key = entry.getKey().asString('.');
            if (value instanceof DataView) {
                CompoundNBT inner = new CompoundNBT();
                NbtTranslator.containerToCompound(container.getView(entry.getKey()).get(), inner);
                compound.put(key, (INBT)inner);
                continue;
            }
            if (value instanceof Boolean) {
                compound.put(key + BOOLEAN_IDENTIFIER, (INBT)ByteNBT.valueOf((boolean)((Boolean)value)));
                continue;
            }
            compound.put(key, NbtTranslator.getBaseFromObject(value));
        }
    }

    private static INBT getBaseFromObject(Object value) {
        Preconditions.checkNotNull((Object)value);
        if (value instanceof Boolean) {
            return ByteNBT.valueOf((boolean)((Boolean)value));
        }
        if (value instanceof Byte) {
            return ByteNBT.valueOf((byte)((Byte)value));
        }
        if (value instanceof Short) {
            return ShortNBT.valueOf((short)((Short)value));
        }
        if (value instanceof Integer) {
            return IntNBT.valueOf((int)((Integer)value));
        }
        if (value instanceof Long) {
            return LongNBT.valueOf((long)((Long)value));
        }
        if (value instanceof Float) {
            return FloatNBT.valueOf((float)((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return DoubleNBT.valueOf((double)((Double)value));
        }
        if (value instanceof String) {
            return StringNBT.valueOf((String)((String)value));
        }
        if (value.getClass().isArray()) {
            if (value instanceof byte[]) {
                return new ByteArrayNBT((byte[])value);
            }
            if (value instanceof Byte[]) {
                byte[] array = new byte[((Byte[])value).length];
                int counter = 0;
                for (Byte data : (Byte[])value) {
                    array[counter++] = data;
                }
                return new ByteArrayNBT(array);
            }
            if (value instanceof int[]) {
                return new IntArrayNBT((int[])value);
            }
            if (value instanceof Integer[]) {
                int[] array = new int[((Integer[])value).length];
                int counter = 0;
                for (Integer data : (Integer[])value) {
                    array[counter++] = data;
                }
                return new IntArrayNBT(array);
            }
            if (value instanceof long[]) {
                return new LongArrayNBT((long[])value);
            }
            if (value instanceof Long[]) {
                long[] array = new long[((Long[])value).length];
                int counter = 0;
                for (Long data : (Long[])value) {
                    array[counter++] = data;
                }
                return new LongArrayNBT(array);
            }
        } else {
            if (value instanceof List) {
                ListNBT list = new ListNBT();
                for (Object object : (List)value) {
                    list.add((Object)NbtTranslator.getBaseFromObject(object));
                }
                return list;
            }
            if (value instanceof Map) {
                CompoundNBT compound = new CompoundNBT();
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    if (entry.getKey() instanceof DataQuery) {
                        if (entry.getValue() instanceof Boolean) {
                            compound.putBoolean(((DataQuery)entry.getKey()).asString('.') + BOOLEAN_IDENTIFIER, ((Boolean)entry.getValue()).booleanValue());
                            continue;
                        }
                        compound.put(((DataQuery)entry.getKey()).asString('.'), NbtTranslator.getBaseFromObject(entry.getValue()));
                        continue;
                    }
                    if (entry.getKey() instanceof String) {
                        compound.put((String)entry.getKey(), NbtTranslator.getBaseFromObject(entry.getValue()));
                        continue;
                    }
                    compound.put(entry.getKey().toString(), NbtTranslator.getBaseFromObject(entry.getValue()));
                }
                return compound;
            }
            if (value instanceof DataSerializable) {
                return NbtTranslator.containerToCompound(((DataSerializable)value).toContainer());
            }
            if (value instanceof DataView) {
                return NbtTranslator.containerToCompound((DataView)value);
            }
        }
        throw new IllegalArgumentException("Unable to translate object to NBTBase: " + value);
    }

    private static DataContainer getViewFromCompound(CompoundNBT compound) {
        Preconditions.checkNotNull((Object)compound);
        DataContainer container = DataContainer.createNew(DataView.SafetyMode.NO_DATA_CLONED);
        NbtTranslator.getInstance().addTo(compound, (DataView)container);
        return container;
    }

    private static void setInternal(INBT base, byte type, DataView view, String key) {
        Preconditions.checkNotNull((Object)base);
        Preconditions.checkNotNull((Object)view);
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkArgument((!key.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((type > 0 && type <= 11 ? 1 : 0) != 0);
        switch (type) {
            case 1: {
                if (key.contains(BOOLEAN_IDENTIFIER)) {
                    view.set(DataQuery.of(key.replace(BOOLEAN_IDENTIFIER, "")), ((ByteNBT)base).getByte() != 0);
                    break;
                }
                view.set(DataQuery.of(key), ((ByteNBT)base).getByte());
                break;
            }
            case 2: {
                view.set(DataQuery.of(key), ((ShortNBT)base).getShort());
                break;
            }
            case 3: {
                view.set(DataQuery.of(key), ((IntNBT)base).getInt());
                break;
            }
            case 4: {
                view.set(DataQuery.of(key), ((LongNBT)base).getLong());
                break;
            }
            case 5: {
                view.set(DataQuery.of(key), Float.valueOf(((FloatNBT)base).getFloat()));
                break;
            }
            case 6: {
                view.set(DataQuery.of(key), ((DoubleNBT)base).getDouble());
                break;
            }
            case 7: {
                view.set(DataQuery.of(key), ((ByteArrayNBT)base).getByteArray());
                break;
            }
            case 8: {
                view.set(DataQuery.of(key), base.getString());
                break;
            }
            case 9: {
                ListNBT list = (ListNBT)base;
                byte listType = (byte)list.getTagType();
                int count = list.size();
                ArrayList objectList = Lists.newArrayListWithCapacity((int)count);
                for (int i = 0; i < count; ++i) {
                    objectList.add(NbtTranslator.fromTagBase(list.get(i), listType));
                }
                view.set(DataQuery.of(key), objectList);
                break;
            }
            case 10: {
                DataView internalView = view.createView(DataQuery.of(key));
                CompoundNBT compound = (CompoundNBT)base;
                for (String internalKey : compound.keySet()) {
                    INBT internalBase = compound.get(internalKey);
                    byte internalType = internalBase.getId();
                    NbtTranslator.setInternal(internalBase, internalType, internalView, internalKey);
                }
                break;
            }
            case 11: {
                view.set(DataQuery.of(key), ((IntArrayNBT)base).getIntArray());
                break;
            }
            case 12: {
                view.set(DataQuery.of(key), ((LongArrayNBTAccessor)base).accessor$getData());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown NBT type " + type);
            }
        }
    }

    private static Object fromTagBase(INBT base, byte type) {
        switch (type) {
            case 1: {
                return ((ByteNBT)base).getByte();
            }
            case 2: {
                return ((ShortNBT)base).getShort();
            }
            case 3: {
                return ((IntNBT)base).getInt();
            }
            case 4: {
                return ((LongNBT)base).getLong();
            }
            case 5: {
                return Float.valueOf(((FloatNBT)base).getFloat());
            }
            case 6: {
                return ((DoubleNBT)base).getDouble();
            }
            case 7: {
                return ((ByteArrayNBT)base).getByteArray();
            }
            case 8: {
                return ((StringNBT)base).getString();
            }
            case 9: {
                ListNBT list = (ListNBT)base;
                byte listType = (byte)list.getTagType();
                int count = list.size();
                ArrayList objectList = Lists.newArrayListWithCapacity((int)count);
                for (INBT inbt : list) {
                    objectList.add(NbtTranslator.fromTagBase(inbt, listType));
                }
                return objectList;
            }
            case 10: {
                return NbtTranslator.getViewFromCompound((CompoundNBT)base);
            }
            case 11: {
                return ((IntArrayNBT)base).getIntArray();
            }
            case 12: {
                return ((LongArrayNBTAccessor)base).accessor$getData();
            }
        }
        return null;
    }

    public void translateContainerToData(CompoundNBT node, DataView container) {
        NbtTranslator.containerToCompound(container, node);
    }

    public DataContainer translateFrom(CompoundNBT node) {
        return NbtTranslator.getViewFromCompound(node);
    }

    @Override
    public TypeToken<CompoundNBT> getToken() {
        return TOKEN;
    }

    @Override
    public CompoundNBT translate(DataView view) throws InvalidDataException {
        return NbtTranslator.containerToCompound(view);
    }

    @Override
    public DataContainer translate(CompoundNBT obj) throws InvalidDataException {
        return NbtTranslator.getViewFromCompound(obj);
    }

    @Override
    public DataView addTo(CompoundNBT compound, DataView container) {
        for (String key : compound.keySet()) {
            INBT base = compound.get(key);
            byte type = base.getId();
            NbtTranslator.setInternal(base, type, container, key);
        }
        return container;
    }
}

