/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.provider.block.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.minecraft.block.StandingSignBlock;
import net.minecraft.block.WallSignBlock;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.SignTileEntity;
import net.minecraft.util.Direction;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.world.ServerLocation;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.data.provider.DataProviderRegistrator;
import org.spongepowered.common.util.DirectionUtil;
import org.spongepowered.common.util.RotationUtils;

public final class SignData {
    private SignData() {
    }

    public static void register(DataProviderRegistrator registrator) {
        ((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)registrator.asMutable(SignTileEntity.class).create(Keys.SIGN_LINES).get(SignData::getSignLines)).set(SignData::setSignLines)).delete(h2 -> SignData.setSignLines(h2, Collections.emptyList()))).create(Keys.DIRECTION).get(h2 -> {
            if (h2.getBlockState().getBlock() instanceof StandingSignBlock) {
                return RotationUtils.getFor((Integer)h2.getBlockState().get((IProperty)StandingSignBlock.ROTATION));
            }
            if (h2.getBlockState().getBlock() instanceof WallSignBlock) {
                return DirectionUtil.getFor((Direction)h2.getBlockState().get((IProperty)WallSignBlock.FACING));
            }
            return null;
        })).setAnd((h2, v) -> {
            if (h2.getBlockState().getBlock() instanceof StandingSignBlock) {
                h2.getWorld().setBlockState(h2.getPos(), RotationUtils.set(h2.getBlockState(), v, (IProperty<Integer>)StandingSignBlock.ROTATION));
                return true;
            }
            if (h2.getBlockState().getBlock() instanceof WallSignBlock) {
                h2.getWorld().setBlockState(h2.getPos(), DirectionUtil.set(h2.getBlockState(), v, WallSignBlock.FACING));
                return true;
            }
            return false;
        })).supports(h2 -> h2.getWorld() != null)).asMutable(ServerLocation.class).create(Keys.SIGN_LINES).get(SignData::getSignLines)).set(SignData::setSignLines)).delete(h2 -> SignData.setSignLines(h2, Collections.emptyList()))).supports(loc -> loc.getBlockEntity().map(b -> b instanceof SignTileEntity).orElse(false));
    }

    private static SignTileEntity toSignTileEntity(ServerLocation holder) {
        return (SignTileEntity)holder.getBlockEntity().get();
    }

    private static void setSignLines(ServerLocation holder, List<Component> value) {
        SignData.setSignLines(SignData.toSignTileEntity(holder), value);
    }

    private static void setSignLines(SignTileEntity holder, List<Component> value) {
        for (int i = 0; i < holder.signText.length; ++i) {
            holder.signText[i] = SpongeAdventure.asVanilla((Component)(i > value.size() - 1 ? Component.empty() : value.get(i)));
        }
        holder.markDirty();
        holder.getWorld().notifyBlockUpdate(holder.getPos(), holder.getBlockState(), holder.getBlockState(), 3);
    }

    private static List<Component> getSignLines(ServerLocation h2) {
        return SignData.getSignLines(SignData.toSignTileEntity(h2));
    }

    private static List<Component> getSignLines(SignTileEntity h2) {
        ArrayList<Component> lines = new ArrayList<Component>(h2.signText.length);
        for (int i = 0; i < h2.signText.length; ++i) {
            lines.add(SpongeAdventure.asAdventure(h2.signText[i]));
        }
        return lines;
    }
}

