/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.provider.entity;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.type.BodyParts;
import org.spongepowered.api.effect.potion.PotionEffect;
import org.spongepowered.common.accessor.entity.EntityAccessor;
import org.spongepowered.common.accessor.entity.LivingEntityAccessor;
import org.spongepowered.common.bridge.entity.LivingEntityBridge;
import org.spongepowered.common.data.provider.DataProviderRegistrator;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.registry.builtin.sponge.DamageTypeStreamGenerator;
import org.spongepowered.common.util.PotionEffectUtil;
import org.spongepowered.math.vector.Vector3d;

public final class LivingData {
    private LivingData() {
    }

    public static void register(DataProviderRegistrator registrator) {
        ((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)registrator.asMutable(LivingEntity.class).create(Keys.ABSORPTION).get(h2 -> h2.getAbsorptionAmount())).setAnd((h2, v) -> {
            if (v < 0.0) {
                return false;
            }
            h2.setAbsorptionAmount(v.floatValue());
            return true;
        })).create(Keys.ACTIVE_ITEM).get(h2 -> ItemStackUtil.snapshotOf(h2.getActiveItemStack()))).setAnd((h2, v) -> {
            if (v.isEmpty()) {
                h2.stopActiveHand();
                return true;
            }
            return false;
        })).delete(LivingEntity::stopActiveHand)).create(Keys.BODY_ROTATIONS).get(h2 -> {
            double headYaw = h2.getRotationYawHead();
            double pitch = h2.rotationPitch;
            double yaw = h2.rotationYaw;
            return ImmutableMap.of((Object)BodyParts.HEAD.get(), (Object)new Vector3d(pitch, headYaw, 0.0), (Object)BodyParts.CHEST.get(), (Object)new Vector3d(pitch, yaw, 0.0));
        })).set((h2, v) -> {
            Vector3d headRotation = (Vector3d)v.get(BodyParts.HEAD.get());
            Vector3d bodyRotation = (Vector3d)v.get(BodyParts.CHEST.get());
            if (bodyRotation != null) {
                h2.rotationYaw = (float)bodyRotation.getY();
                h2.rotationPitch = (float)bodyRotation.getX();
            }
            if (headRotation != null) {
                h2.rotationYawHead = (float)headRotation.getY();
                h2.rotationPitch = (float)headRotation.getX();
            }
        })).create(Keys.CHEST_ROTATION).get(h2 -> new Vector3d(h2.rotationPitch, h2.rotationYaw, 0.0f))).set((h2, v) -> {
            float headYaw = (float)v.getY();
            float pitch = (float)v.getX();
            h2.setRotationYawHead(headYaw);
            h2.rotationPitch = pitch;
        })).create(Keys.HEAD_ROTATION).get(h2 -> new Vector3d(h2.rotationPitch, h2.getRotationYawHead(), 0.0f))).set((h2, v) -> {
            float yaw = (float)v.getY();
            float pitch = (float)v.getX();
            h2.rotationYaw = yaw;
            h2.rotationPitch = pitch;
        })).create(Keys.HEALTH).get(h2 -> h2.getHealth())).setAnd((h2, v) -> {
            double maxHealth = h2.getMaxHealth();
            if (v < 0.0 || v > maxHealth) {
                return false;
            }
            h2.setHealth(v.floatValue());
            if (v == 0.0) {
                h2.attackEntityFrom(DamageTypeStreamGenerator.IGNORED_DAMAGE_SOURCE, 1000.0f);
            }
            return true;
        })).create(Keys.IS_ELYTRA_FLYING).get(LivingEntity::isElytraFlying)).set((h2, v) -> ((EntityAccessor)h2).accessor$setFlag(7, (boolean)v))).create(Keys.LAST_ATTACKER).get(h2 -> (org.spongepowered.api.entity.Entity)h2.getRevengeTarget())).setAnd((h2, v) -> {
            if (v instanceof LivingEntity) {
                h2.setRevengeTarget((LivingEntity)v);
                return true;
            }
            return false;
        })).delete(h2 -> h2.setRevengeTarget(null))).create(Keys.MAX_AIR).get(Entity::getMaxAir)).set((h2, v) -> ((LivingEntityBridge)h2).bridge$setMaxAir((int)v))).create(Keys.MAX_HEALTH).get(h2 -> h2.getMaxHealth())).set((h2, v) -> h2.getAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(v.doubleValue()))).create(Keys.POTION_EFFECTS).get(h2 -> {
            Collection effects = h2.getActivePotionEffects();
            return effects.isEmpty() ? null : PotionEffectUtil.copyAsPotionEffects(effects);
        })).set((h2, v) -> {
            h2.clearActivePotions();
            for (PotionEffect effect : v) {
                h2.addPotionEffect(PotionEffectUtil.copyAsEffectInstance(effect));
            }
        })).delete(LivingEntity::clearActivePotions)).create(Keys.REMAINING_AIR).get(h2 -> Math.max(0, h2.getAir()))).setAnd((h2, v) -> {
            if (v < 0 || v > h2.getMaxAir()) {
                return false;
            }
            if (v == 0 && h2.getAir() < 0) {
                return false;
            }
            h2.setAir(v.intValue());
            return true;
        })).create(Keys.SCALE).get(h2 -> h2.getRenderScale())).create(Keys.STUCK_ARROWS).get(LivingEntity::getArrowCountInEntity)).setAnd((h2, v) -> {
            if (v < 0 || v > Integer.MAX_VALUE) {
                return false;
            }
            h2.setArrowCountInEntity(v.intValue());
            return true;
        })).create(Keys.WALKING_SPEED).get(h2 -> h2.getAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).getValue())).setAnd((h2, v) -> {
            if (v < 0.0) {
                return false;
            }
            h2.getAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(v.doubleValue());
            return true;
        })).asMutable(LivingEntityAccessor.class).create(Keys.LAST_DAMAGE_RECEIVED).get(h2 -> h2.accessor$getLastDamage())).set((h2, v) -> h2.accessor$setLastDamage(v.floatValue()));
    }
}

