/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.provider.item.stack;

import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.item.BannerItem;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.LockCode;
import org.spongepowered.api.data.Keys;
import org.spongepowered.common.bridge.block.DyeColorBlockBridge;
import org.spongepowered.common.data.provider.DataProviderRegistrator;

public final class BlockItemStackData {
    private BlockItemStackData() {
    }

    public static void register(DataProviderRegistrator registrator) {
        ((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)registrator.asMutable(ItemStack.class).create(Keys.DYE_COLOR).get(h2 -> {
            Block block = ((BlockItem)h2.getItem()).getBlock();
            return ((DyeColorBlockBridge)block).bridge$getDyeColor().orElse(null);
        })).supports(h2 -> h2.getItem() instanceof BlockItem && !(h2.getItem() instanceof BannerItem))).create(Keys.LOCK_TOKEN).get(h2 -> {
            String lock;
            CompoundNBT tag = h2.getChildTag("BlockEntityTag");
            if (tag != null && !(lock = tag.getString("Lock")).isEmpty()) {
                return lock;
            }
            return null;
        })).set((h2, v) -> {
            if (v.isEmpty()) {
                BlockItemStackData.deleteLockToken(h2);
                return;
            }
            new LockCode(v).write(h2.getOrCreateChildTag("BlockEntityTag"));
        })).delete(BlockItemStackData::deleteLockToken)).supports(h2 -> {
            if (!(h2.getItem() instanceof BlockItem)) {
                return false;
            }
            Block block = ((BlockItem)h2.getItem()).getBlock();
            if (!(block instanceof ITileEntityProvider)) {
                return false;
            }
            try {
                TileEntity tile = ((ITileEntityProvider)block).createNewTileEntity(null);
                return tile instanceof LockableTileEntity;
            }
            catch (NullPointerException ex) {
                return false;
            }
        });
    }

    private static void deleteLockToken(ItemStack stack) {
        CompoundNBT tag = stack.getChildTag("BlockEntityTag");
        if (tag != null) {
            tag.remove("Lock");
        }
    }
}

