/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.provider.item.stack;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.item.BannerItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShieldItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.BannerPattern;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.meta.BannerPatternLayer;
import org.spongepowered.api.data.type.BannerPatternShape;
import org.spongepowered.api.data.type.BannerPatternShapes;
import org.spongepowered.api.data.type.DyeColor;
import org.spongepowered.api.data.type.DyeColors;
import org.spongepowered.common.data.provider.DataProviderRegistrator;
import org.spongepowered.common.util.NBTCollectors;

public final class ShieldItemStackData {
    private static final Map<String, BannerPatternShape> SHAPE_BY_HASHNAME = new HashMap<String, BannerPatternShape>();

    private ShieldItemStackData() {
    }

    public static void register(DataProviderRegistrator registrator) {
        ((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)registrator.asMutable(ItemStack.class).create(Keys.DYE_COLOR).get(h2 -> {
            CompoundNBT tag = h2.getChildTag("BlockEntityTag");
            if (tag == null || tag.contains("Patterns", 9)) {
                return DyeColors.WHITE.get();
            }
            int id = tag.getInt("Base");
            return (DyeColor)net.minecraft.item.DyeColor.byId((int)id);
        })).set((h2, v) -> {
            CompoundNBT tag = h2.getOrCreateChildTag("BlockEntityTag");
            tag.putInt("Base", ((net.minecraft.item.DyeColor)v).getId());
        })).supports(h2 -> h2.getItem() instanceof ShieldItem)).create(Keys.BANNER_PATTERN_LAYERS).get(h2 -> {
            CompoundNBT tag = h2.getChildTag("BlockEntityTag");
            if (tag == null || !tag.contains("Patterns", 9)) {
                return new ArrayList();
            }
            ListNBT layersList = tag.getList("Patterns", 10);
            return layersList.stream().map(layer -> ShieldItemStackData.layerFromNbt((CompoundNBT)layer)).collect(Collectors.toList());
        })).set((h2, v) -> {
            ListNBT layersTag = v.stream().filter(layer -> layer.getShape() != BannerPatternShapes.BASE.get()).map(ShieldItemStackData::layerToNbt).collect(NBTCollectors.toTagList());
            CompoundNBT blockEntity = h2.getOrCreateChildTag("BlockEntityTag");
            blockEntity.put("Patterns", (INBT)layersTag);
            if (h2.getItem() instanceof ShieldItem) {
                v.stream().filter(layer -> layer.getShape() == BannerPatternShapes.BASE.get()).forEach(layer -> blockEntity.putInt("Base", ((net.minecraft.item.DyeColor)layer.getColor()).getId()));
            }
        })).supports(h2 -> h2.getItem() instanceof ShieldItem || h2.getItem() instanceof BannerItem);
    }

    public static BannerPatternLayer layerFromNbt(CompoundNBT nbt) {
        BannerPatternShape shape = SHAPE_BY_HASHNAME.get(nbt.getString("Pattern"));
        net.minecraft.item.DyeColor dyeColor = net.minecraft.item.DyeColor.byId((int)nbt.getInt("Color"));
        return BannerPatternLayer.of(shape, (DyeColor)dyeColor);
    }

    public static CompoundNBT layerToNbt(BannerPatternLayer layer) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.putString("Pattern", ((BannerPattern)layer.getShape()).getHashname());
        nbt.putInt("Color", ((net.minecraft.item.DyeColor)layer.getColor()).getId());
        return nbt;
    }

    static {
        for (BannerPattern pattern : BannerPattern.values()) {
            SHAPE_BY_HASHNAME.put(pattern.getHashname(), (BannerPatternShape)pattern);
        }
    }
}

