/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.value;

import org.spongepowered.api.data.value.Value;
import org.spongepowered.common.data.value.ValueConstructor;

final class CachedBooleanValueConstructor
implements ValueConstructor<Value<Boolean>, Boolean> {
    private final ValueConstructor<Value<Boolean>, Boolean> original;
    private final Value<Boolean> immutableValueTrue;
    private final Value<Boolean> immutableValueFalse;

    CachedBooleanValueConstructor(ValueConstructor<Value<Boolean>, Boolean> original) {
        this.original = original;
        this.immutableValueFalse = original.getImmutable(false);
        this.immutableValueTrue = original.getImmutable(true);
    }

    @Override
    public Value<Boolean> getMutable(Boolean element) {
        return this.original.getMutable(element);
    }

    @Override
    public Value<Boolean> getImmutable(Boolean element) {
        return element != false ? this.immutableValueTrue : this.immutableValueFalse;
    }

    @Override
    public Value<Boolean> getRawImmutable(Boolean element) {
        return this.getImmutable(element);
    }
}

