/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.value;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.value.MapValue;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.common.data.key.SpongeKey;
import org.spongepowered.common.data.value.AbstractImmutableSpongeValue;
import org.spongepowered.common.data.value.MutableSpongeMapValue;

public final class ImmutableSpongeMapValue<K, V>
extends AbstractImmutableSpongeValue<Map<K, V>>
implements MapValue.Immutable<K, V> {
    public ImmutableSpongeMapValue(Key<? extends Value<Map<K, V>>> key, Map<K, V> element) {
        super(key, element);
    }

    @Override
    public SpongeKey<? extends MapValue<K, V>, Map<K, V>> getKey() {
        return super.getKey();
    }

    @Override
    public int size() {
        return ((Map)this.element).size();
    }

    @Override
    public boolean containsKey(K key) {
        return ((Map)this.element).containsKey(key);
    }

    @Override
    public boolean containsValue(V value) {
        return ((Map)this.element).containsValue(value);
    }

    @Override
    public Set<K> keySet() {
        return ((Map)this.element).keySet();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return ((Map)this.element).entrySet();
    }

    @Override
    public Collection<V> values() {
        return ((Map)this.element).values();
    }

    @Override
    public MapValue.Immutable<K, V> transform(Function<Map<K, V>, Map<K, V>> function) {
        return this.with(function.apply((Map<K, V>)this.get()));
    }

    @Override
    public MapValue.Immutable<K, V> with(Map<K, V> value) {
        return ((MapValue)((SpongeKey)this.getKey()).getValueConstructor().getImmutable(value)).asImmutable();
    }

    @Override
    public MapValue.Immutable<K, V> with(K key, V value) {
        return this.modifyMap(map -> map.put(key, value));
    }

    private MapValue.Immutable<K, V> modifyMap(Consumer<Map<K, V>> consumer) {
        ImmutableMap map;
        if (this.element instanceof LinkedHashMap) {
            map = new LinkedHashMap((Map)this.element);
            consumer.accept((Map<K, V>)map);
        } else if (this.element instanceof ImmutableMap) {
            LinkedHashMap temp = new LinkedHashMap((Map)this.element);
            consumer.accept(temp);
            map = ImmutableMap.copyOf(temp);
        } else {
            map = new HashMap((Map)this.element);
            consumer.accept((Map<K, V>)map);
        }
        return ((MapValue)((SpongeKey)this.getKey()).getValueConstructor().getRawImmutable(map)).asImmutable();
    }

    @Override
    public MapValue.Immutable<K, V> withAll(Map<K, V> other) {
        return this.modifyMap(map -> map.putAll(other));
    }

    @Override
    public MapValue.Immutable<K, V> without(K key) {
        if (!((Map)this.element).containsKey(key)) {
            return this;
        }
        return this.modifyMap(map -> map.remove(key));
    }

    @Override
    public MapValue.Immutable<K, V> withoutAll(Iterable<K> keys) {
        if (Streams.stream(keys).noneMatch(key -> ((Map)this.element).containsKey(key))) {
            return this;
        }
        return this.modifyMap(map -> keys.forEach(map::remove));
    }

    @Override
    public MapValue.Immutable<K, V> withoutAll(Predicate<Map.Entry<K, V>> predicate) {
        return this.modifyMap(map -> map.entrySet().removeIf(predicate));
    }

    @Override
    public MapValue.Mutable<K, V> asMutable() {
        return new MutableSpongeMapValue(this.getKey(), (Map)this.get());
    }
}

