/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.value;

import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.value.CollectionValue;
import org.spongepowered.common.data.value.AbstractMutableSpongeValue;

public abstract class MutableSpongeCollectionValue<E, C extends Collection<E>, V extends CollectionValue.Mutable<E, C, V, I>, I extends CollectionValue.Immutable<E, C, I, V>>
extends AbstractMutableSpongeValue<C>
implements CollectionValue.Mutable<E, C, V, I> {
    public MutableSpongeCollectionValue(Key<? extends CollectionValue<E, C>> key, C element) {
        super(key, element);
    }

    @Override
    public int size() {
        return ((Collection)this.element).size();
    }

    @Override
    public boolean isEmpty() {
        return ((Collection)this.element).isEmpty();
    }

    @Override
    public boolean contains(E element) {
        return ((Collection)this.element).contains(element);
    }

    @Override
    public boolean containsAll(Iterable<E> iterable) {
        if (iterable instanceof Collection) {
            return ((Collection)this.element).containsAll((Collection)iterable);
        }
        return Streams.stream(iterable).allMatch(this::contains);
    }

    @Override
    public C getAll() {
        return (C)((Collection)this.element);
    }

    protected abstract V modifyCollection(Consumer<C> var1);

    @Override
    public V add(E element) {
        return this.modifyCollection(collection -> collection.add(element));
    }

    @Override
    public V addAll(Iterable<E> elements) {
        return this.modifyCollection(collection -> Iterables.addAll((Collection)collection, (Iterable)elements));
    }

    @Override
    public V remove(E element) {
        if (!this.contains(element)) {
            return (V)this;
        }
        return this.modifyCollection(collection -> collection.remove(element));
    }

    @Override
    public V removeAll(Iterable<E> elements) {
        if (Streams.stream(elements).noneMatch(this::contains)) {
            return (V)this;
        }
        return this.modifyCollection(collection -> elements.forEach(collection::remove));
    }

    @Override
    public V removeAll(Predicate<E> predicate) {
        return this.modifyCollection(collection -> collection.removeIf(predicate));
    }

    @Override
    public V set(C value) {
        super.set(value);
        return (V)this;
    }

    @Override
    public V transform(Function<C, C> function) {
        return this.set((C)((Collection)function.apply(this.get())));
    }

    @Override
    public Iterator<E> iterator() {
        return ((Collection)this.element).iterator();
    }
}

