/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.effect.record;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import net.minecraft.item.MusicDiscItem;
import net.minecraft.network.play.server.SPlaySoundEventPacket;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.effect.sound.SoundType;
import org.spongepowered.api.effect.sound.music.MusicDisc;
import org.spongepowered.common.SpongeCatalogType;
import org.spongepowered.common.accessor.item.MusicDiscItemAccessor;
import org.spongepowered.math.vector.Vector3i;

public final class SpongeRecordType
extends SpongeCatalogType
implements MusicDisc {
    private static final int EFFECT_ID = 1010;
    private final MusicDiscItem item;
    private final int id;

    public SpongeRecordType(ResourceKey key, MusicDiscItem item) {
        super(key);
        this.item = item;
        this.id = Registry.ITEM.getId((Object)item);
    }

    public int getId() {
        return this.id;
    }

    @Override
    public SoundType getSound() {
        return (SoundType)((MusicDiscItemAccessor)this.item).accessor$getSound();
    }

    public static SPlaySoundEventPacket createPacket(Vector3i position, @Nullable MusicDisc recordType) {
        Preconditions.checkNotNull((Object)position, (Object)"position");
        BlockPos pos = new BlockPos(position.getX(), position.getY(), position.getZ());
        return new SPlaySoundEventPacket(1010, pos, recordType == null ? 0 : ((SpongeRecordType)recordType).getId(), false);
    }
}

