/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.MobEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.entity.EntitySnapshot;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.entity.SpawnType;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.world.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.bridge.data.DataContainerHolder;
import org.spongepowered.common.bridge.world.storage.WorldInfoBridge;
import org.spongepowered.common.data.AbstractArchetype;
import org.spongepowered.common.data.SpongeDataManager;
import org.spongepowered.common.data.nbt.validation.RawDataValidator;
import org.spongepowered.common.data.nbt.validation.ValidationType;
import org.spongepowered.common.data.nbt.validation.Validations;
import org.spongepowered.common.data.persistence.NbtTranslator;
import org.spongepowered.common.data.provider.DataProviderLookup;
import org.spongepowered.common.entity.SpongeEntityArchetypeBuilder;
import org.spongepowered.common.entity.SpongeEntitySnapshotBuilder;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.hooks.SpongeImplHooks;
import org.spongepowered.common.util.Constants;
import org.spongepowered.math.vector.Vector3d;

public class SpongeEntityArchetype
extends AbstractArchetype<EntityType, EntitySnapshot, Entity>
implements EntityArchetype,
DataContainerHolder.Mutable {
    public static final ImmutableList<RawDataValidator> VALIDATORS = ImmutableList.of();
    private static final DataProviderLookup lookup = SpongeDataManager.getProviderRegistry().getProviderLookup(SpongeEntityArchetype.class);
    @Nullable
    private Vector3d position;

    SpongeEntityArchetype(SpongeEntityArchetypeBuilder builder) {
        super(builder.entityType, builder.compound != null ? builder.compound : (builder.entityData == null ? new CompoundNBT() : NbtTranslator.getInstance().translate(builder.entityData)));
    }

    @Override
    public EntityType<?> getType() {
        return (EntityType)this.type;
    }

    @Nullable
    public CompoundNBT getData() {
        return this.data;
    }

    @Override
    public DataProviderLookup getLookup() {
        return lookup;
    }

    public Optional<Vector3d> getPosition() {
        if (this.position != null) {
            return Optional.of(this.position);
        }
        if (!this.data.contains("Pos", 9)) {
            return Optional.empty();
        }
        try {
            ListNBT pos = this.data.getList("Pos", 6);
            double x = pos.getDouble(0);
            double y = pos.getDouble(1);
            double z = pos.getDouble(2);
            this.position = new Vector3d(x, y, z);
            return Optional.of(this.position);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    @Override
    public DataContainer data$getDataContainer() {
        return this.getEntityData();
    }

    @Override
    public void data$setDataContainer(DataContainer container) {
        this.data = NbtTranslator.getInstance().translate(container);
    }

    @Override
    public DataContainer getEntityData() {
        return NbtTranslator.getInstance().translateFrom(this.data);
    }

    @Override
    public Optional<Entity> apply(ServerLocation location) {
        boolean requiresInitialSpawn;
        if (!SpongeImplHooks.onServerThread()) {
            return Optional.empty();
        }
        ServerWorld spongeWorld = (ServerWorld)location.getWorld();
        net.minecraft.world.server.ServerWorld worldServer = (net.minecraft.world.server.ServerWorld)spongeWorld;
        net.minecraft.entity.Entity entity = ((net.minecraft.entity.EntityType)this.type).create((World)worldServer);
        if (entity == null) {
            return Optional.empty();
        }
        entity.setPosition(location.getX(), location.getY(), location.getZ());
        if (this.data.contains("RequireInitialSpawn")) {
            requiresInitialSpawn = !this.data.getBoolean("RequireInitialSpawn");
            this.data.remove("RequireInitialSpawn");
        } else {
            requiresInitialSpawn = true;
        }
        if (entity instanceof MobEntity) {
            MobEntity mobentity = (MobEntity)entity;
            mobentity.rotationYawHead = mobentity.rotationYaw;
            mobentity.renderYawOffset = mobentity.rotationYaw;
            if (requiresInitialSpawn) {
                mobentity.onInitialSpawn((IWorld)worldServer, worldServer.getDifficultyForLocation(new BlockPos((net.minecraft.entity.Entity)mobentity)), null, null, null);
            }
        }
        CompoundNBT mergedNbt = entity.writeWithoutTypeId(new CompoundNBT());
        UUID uniqueID = entity.getUniqueID();
        mergedNbt.merge(this.data);
        mergedNbt.remove("RequireInitialSpawn");
        Integer dimensionId = ((WorldInfoBridge)((Object)((ServerWorld)location.getWorld()).getProperties())).bridge$getDimensionId();
        mergedNbt.putInt("Dimension", dimensionId.intValue());
        mergedNbt.putUniqueId("UUID", uniqueID);
        entity.read(mergedNbt);
        entity.setPosition(location.getX(), location.getY(), location.getZ());
        Entity spongeEntity = (Entity)entity;
        ArrayList<Entity> entities = new ArrayList<Entity>();
        entities.add(spongeEntity);
        SpawnType require = PhaseTracker.getCauseStackManager().getCurrentContext().require(EventContextKeys.SPAWN_TYPE);
        SpawnEntityEvent.Custom event = SpongeEventFactory.createSpawnEntityEventCustom(PhaseTracker.getCauseStackManager().getCurrentCause(), entities);
        if (!event.isCancelled()) {
            worldServer.addEntity(entity);
            return Optional.of(spongeEntity);
        }
        return Optional.empty();
    }

    @Override
    public EntitySnapshot toSnapshot(ServerLocation location) {
        SpongeEntitySnapshotBuilder builder = new SpongeEntitySnapshotBuilder();
        builder.entityType = (EntityType)this.type;
        CompoundNBT newCompound = this.data.copy();
        Vector3d pos = location.getPosition();
        newCompound.put("Pos", (INBT)Constants.NBT.newDoubleNBTList(pos.getX(), pos.getY(), pos.getZ()));
        newCompound.putInt("Dimension", ((WorldInfoBridge)((Object)((ServerWorld)location.getWorld()).getProperties())).bridge$getDimensionId().intValue());
        builder.compound = newCompound;
        builder.worldKey = ((ServerWorld)location.getWorld()).getProperties().getKey();
        builder.position = pos;
        builder.rotation = this.getRotation();
        builder.scale = Vector3d.ONE;
        return builder.build();
    }

    private Vector3d getRotation() {
        ListNBT listnbt3 = this.data.getList("Rotation", 5);
        float rotationYaw = listnbt3.getFloat(0);
        float rotationPitch = listnbt3.getFloat(1);
        return new Vector3d(rotationPitch, rotationYaw, 0.0f);
    }

    @Override
    public int getContentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        return DataContainer.createNew().set(Constants.Sponge.EntityArchetype.ENTITY_TYPE, this.type).set(Constants.Sponge.EntityArchetype.ENTITY_DATA, this.getEntityData());
    }

    @Override
    protected ValidationType getValidationType() {
        return Validations.ENTITY;
    }

    @Override
    public EntityArchetype copy() {
        SpongeEntityArchetypeBuilder builder = new SpongeEntityArchetypeBuilder();
        builder.entityType = (EntityType)this.type;
        builder.entityData = NbtTranslator.getInstance().translate(this.data);
        return builder.build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpongeEntityArchetype that = (SpongeEntityArchetype)o;
        return Objects.equals(this.position, that.position);
    }

    @Override
    protected ImmutableList<RawDataValidator> getValidators() {
        return VALIDATORS;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.position);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("position", (Object)this.position).add("type", (Object)this.type).toString();
    }
}

