/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity;

import com.google.common.base.MoreObjects;
import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.entity.EntitySnapshot;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.cause.entity.SpawnTypes;
import org.spongepowered.api.util.Transform;
import org.spongepowered.api.world.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.data.CustomDataHolderBridge;
import org.spongepowered.common.bridge.data.DataContainerHolder;
import org.spongepowered.common.bridge.world.storage.WorldInfoBridge;
import org.spongepowered.common.data.holder.SpongeImmutableDataHolder;
import org.spongepowered.common.data.persistence.NbtTranslator;
import org.spongepowered.common.entity.SpongeEntityArchetypeBuilder;
import org.spongepowered.common.entity.SpongeEntitySnapshotBuilder;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.util.Constants;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

public class SpongeEntitySnapshot
implements EntitySnapshot,
SpongeImmutableDataHolder<EntitySnapshot>,
DataContainerHolder.Immutable<EntitySnapshot> {
    @Nullable
    private final UUID entityUuid;
    private final ResourceKey worldKey;
    private final EntityType<?> entityType;
    private final Vector3d position;
    private final Vector3d rotation;
    private final Vector3d scale;
    @Nullable
    private final CompoundNBT compound;
    @Nullable
    private final WeakReference<org.spongepowered.api.entity.Entity> entityReference;

    SpongeEntitySnapshot(SpongeEntitySnapshotBuilder builder) {
        this.entityType = builder.entityType;
        this.entityUuid = builder.entityId;
        CompoundNBT compoundNBT = this.compound = builder.compound == null ? null : builder.compound.copy();
        if (builder.manipulator != null) {
            ((CustomDataHolderBridge)((Object)this)).bridge$getManipulator().copyFrom(builder.manipulator);
        }
        this.worldKey = builder.worldKey;
        this.position = builder.position;
        this.rotation = builder.rotation;
        this.scale = builder.scale;
        this.entityReference = builder.entityReference;
        if (this.compound != null) {
            this.compound.put("Pos", (INBT)Constants.NBT.newDoubleNBTList(this.position.getX(), this.position.getY(), this.position.getZ()));
        }
    }

    public WeakReference<org.spongepowered.api.entity.Entity> getEntityReference() {
        return this.entityReference;
    }

    @Override
    public Optional<UUID> getUniqueId() {
        return Optional.ofNullable(this.entityUuid);
    }

    @Override
    public Optional<Transform> getTransform() {
        Transform transform = Transform.of(this.position, this.rotation);
        return Optional.of(transform);
    }

    @Override
    public EntityType<?> getType() {
        return this.entityType;
    }

    @Override
    public Optional<ServerLocation> getLocation() {
        Optional<ServerWorld> optional = SpongeCommon.getGame().getServer().getWorldManager().getWorld(this.worldKey);
        if (optional.isPresent()) {
            ServerLocation location = ServerLocation.of(optional.get(), this.position);
            return Optional.of(location);
        }
        return Optional.empty();
    }

    @Override
    public int getContentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        DataContainer unsafeNbt = NbtTranslator.getInstance().translateFrom(this.compound == null ? new CompoundNBT() : this.compound);
        DataContainer container = DataContainer.createNew().set(Queries.CONTENT_VERSION, this.getContentVersion()).set(Queries.WORLD_KEY, this.worldKey.toString()).createView(Constants.Sponge.SNAPSHOT_WORLD_POSITION).set(Queries.POSITION_X, this.position.getX()).set(Queries.POSITION_Y, this.position.getY()).set(Queries.POSITION_Z, this.position.getZ()).getContainer().createView(Constants.Entity.ROTATION).set(Queries.POSITION_X, this.rotation.getX()).set(Queries.POSITION_Y, this.rotation.getY()).set(Queries.POSITION_Z, this.rotation.getZ()).getContainer().createView(Constants.Entity.SCALE).set(Queries.POSITION_X, this.scale.getX()).set(Queries.POSITION_Y, this.scale.getY()).set(Queries.POSITION_Z, this.scale.getZ()).getContainer().set(Constants.Entity.TYPE, this.entityType.getKey()).set(Constants.Sponge.UNSAFE_NBT, unsafeNbt);
        if (this.entityUuid != null) {
            container.set(Constants.Entity.UUID, this.entityUuid.toString());
        }
        return container;
    }

    @Override
    public boolean validateRawData(DataView container) {
        return new SpongeEntitySnapshotBuilder().buildContent(container).isPresent();
    }

    @Override
    public EntitySnapshot withRawData(DataView container) throws InvalidDataException {
        Optional<EntitySnapshot> snap = new SpongeEntitySnapshotBuilder().buildContent(container);
        return snap.orElseThrow(InvalidDataException::new);
    }

    @Override
    public EntitySnapshot copy() {
        return this;
    }

    @Override
    public ResourceKey getWorld() {
        return this.worldKey;
    }

    @Override
    public Vector3i getPosition() {
        return this.position.toInt();
    }

    @Override
    public EntitySnapshot withLocation(ServerLocation location) {
        Objects.requireNonNull(location, "location");
        SpongeEntitySnapshotBuilder builder = this.createBuilder();
        builder.position = location.getPosition();
        builder.worldKey = ((ServerWorld)location.getWorld()).getKey();
        CompoundNBT newCompound = this.compound.copy();
        newCompound.putInt("Dimension", ((WorldInfoBridge)((Object)((ServerWorld)location.getWorld()).getProperties())).bridge$getDimensionId().intValue());
        builder.compound = newCompound;
        return builder.build();
    }

    private SpongeEntitySnapshotBuilder createBuilder() {
        return ((SpongeEntitySnapshotBuilder)new SpongeEntitySnapshotBuilder().type((EntityType)this.getType())).rotation(this.rotation).scale(this.scale);
    }

    public Optional<CompoundNBT> getCompound() {
        if (this.compound == null) {
            return Optional.empty();
        }
        return Optional.of(this.compound.copy());
    }

    @Override
    public Optional<org.spongepowered.api.entity.Entity> restore() {
        Optional entity;
        org.spongepowered.api.entity.Entity entity2;
        if (this.entityReference != null && (entity2 = (org.spongepowered.api.entity.Entity)this.entityReference.get()) != null) {
            return Optional.of(entity2);
        }
        Optional<ServerWorld> world = Sponge.getServer().getWorldManager().getWorld(this.worldKey);
        if (!world.isPresent()) {
            return Optional.empty();
        }
        if (this.entityUuid != null && (entity = world.get().getEntity(this.entityUuid)).isPresent()) {
            return entity;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.PLUGIN);
            org.spongepowered.api.entity.Entity newEntity = world.get().createEntity(this.getType(), this.position);
            if (newEntity != null) {
                boolean spawnResult;
                Entity nmsEntity = (Entity)newEntity;
                if (this.compound != null) {
                    nmsEntity.read(this.compound);
                }
                if (spawnResult = world.get().spawnEntity((org.spongepowered.api.entity.Entity)nmsEntity)) {
                    Optional<org.spongepowered.api.entity.Entity> optional = Optional.of((org.spongepowered.api.entity.Entity)nmsEntity);
                    return optional;
                }
            }
        }
        return Optional.empty();
    }

    @Override
    public EntityArchetype createArchetype() {
        SpongeEntityArchetypeBuilder builder = new SpongeEntityArchetypeBuilder();
        builder.type(this.entityType);
        if (this.compound != null) {
            builder.entityData(NbtTranslator.getInstance().translate(this.compound));
        }
        return builder.build();
    }

    @Override
    public DataContainer data$getDataContainer() {
        if (this.compound == null) {
            return DataContainer.createNew();
        }
        return NbtTranslator.getInstance().translate(this.compound);
    }

    @Override
    public EntitySnapshot data$withDataContainer(DataContainer container) {
        SpongeEntitySnapshotBuilder builder = this.createBuilder();
        builder.worldKey = this.worldKey;
        builder.position = this.position;
        builder.compound = NbtTranslator.getInstance().translate(container);
        return builder.build();
    }

    public int hashCode() {
        return Objects.hash(this.entityUuid, this.worldKey, this.entityType, this.position, this.rotation, this.scale);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SpongeEntitySnapshot other = (SpongeEntitySnapshot)obj;
        return Objects.equals(this.entityUuid, other.entityUuid) && Objects.equals(this.worldKey, other.worldKey) && Objects.equals(this.entityType, other.entityType) && Objects.equals(this.position, other.position) && Objects.equals(this.rotation, other.rotation) && Objects.equals(this.scale, other.scale);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("uniqueId", (Object)this.entityUuid).add("entityType", this.entityType).add("position", (Object)this.position).add("rotation", (Object)this.rotation).add("scale", (Object)this.scale).toString();
    }
}

